/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import orbital.logic.functor.Functionals;
import orbital.logic.functor.Predicates;
import orbital.math.Arithmetic;
import orbital.math.Tensor;
import orbital.math.UnivariatePolynomial;
import orbital.math.Values;
import orbital.moon.math.AbstractUnivariatePolynomial;
import orbital.util.Setops;

class ArithmeticUnivariatePolynomial
extends AbstractUnivariatePolynomial {
    private static final long serialVersionUID = -7008637791438268097L;
    private Arithmetic[] coefficients;
    private transient int degree;

    public ArithmeticUnivariatePolynomial(int degree) {
        this.coefficients = degree < 0 ? new Arithmetic[]{} : new Arithmetic[degree + 1];
        this.degree = Integer.MIN_VALUE;
    }

    public ArithmeticUnivariatePolynomial(Arithmetic[] coefficients) {
        this.set(coefficients);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.set(this.coefficients);
    }

    protected UnivariatePolynomial newInstance(int degree) {
        return new ArithmeticUnivariatePolynomial(degree);
    }

    public final int degreeValue() {
        return this.degree;
    }

    private int degreeImpl(Arithmetic[] coefficients) {
        for (int i = coefficients.length - 1; i >= 0; --i) {
            if (coefficients[i] == null || coefficients[i].norm().equals(Values.ZERO)) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    private void set(Arithmetic[] coefficients) {
        if (coefficients == null) {
            throw new IllegalArgumentException("illegal coefficients array: " + coefficients);
        }
        if (Setops.some(Arrays.asList(coefficients), Functionals.bindSecond(Predicates.equal, null))) {
            throw new IllegalArgumentException("illegal coefficients: containing null");
        }
        this.coefficients = coefficients;
        this.R_ZERO = coefficients.length > 0 ? coefficients[0].zero() : Values.ZERO;
        this.degree = this.degreeImpl(coefficients);
    }

    public Arithmetic get(int i) {
        if (i <= this.degreeValue() && i >= this.coefficients.length) {
            throw new ArrayIndexOutOfBoundsException(this.coefficients.length + "=<" + i + "=<" + this.degreeValue() + "=" + this.degreeImpl(this.coefficients));
        }
        return i <= this.degreeValue() ? this.coefficients[i] : this.R_ZERO;
    }

    public void set(int i, Arithmetic vi) {
        if (vi == null) {
            throw new IllegalArgumentException("illegal coefficient value: " + vi);
        }
        int oldDegree = this.degreeValue();
        if (i >= this.coefficients.length) {
            throw new UnsupportedOperationException("setting coefficients beyond the degree not (always) supported");
        }
        this.coefficients[i] = vi;
        Arithmetic arithmetic = this.R_ZERO = this.coefficients.length > 0 ? this.coefficients[0].zero() : Values.ZERO;
        if (i >= oldDegree) {
            this.degree = this.degreeImpl(this.coefficients);
        }
    }

    public Arithmetic[] getCoefficients() {
        if (this.degreeValue() < 0) {
            return new Arithmetic[0];
        }
        return (Arithmetic[])this.coefficients.clone();
    }

    Tensor tensorViewOfCoefficients() {
        return Values.getDefaultInstance().tensor(this.coefficients);
    }
}

