/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.lang.reflect.Array;
import orbital.algorithm.Combinatorical;
import orbital.math.Arithmetic;
import orbital.math.Tensor;
import orbital.math.Values;
import orbital.moon.math.AbstractTensor;
import orbital.util.Utility;

class ArithmeticTensor
extends AbstractTensor {
    private static final long serialVersionUID = -6766356302306780151L;
    private Object[] D;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ArithmeticTensor(int[] dimensions) {
        this.D = (Object[])Array.newInstance(Arithmetic.class, dimensions);
    }

    public ArithmeticTensor(Object[] values) {
        this((Object)values);
    }

    public ArithmeticTensor(Object values) {
        if (values == null) {
            throw new NullPointerException("illegal tensor " + values);
        }
        if (!values.getClass().isArray()) {
            throw new UnsupportedOperationException("tensors of rank 0 should not get wrapped into tensors of non array type");
        }
        int[] dim = Utility.dimensions(values);
        Utility.pre(this.checkRectangular(dim, 0, values), "multi-dimensional array of " + Arithmetic.class + " expected. found " + values);
        Combinatorical index = Combinatorical.getPermutations(dim);
        boolean primitive = Values.isPrimitiveWrapper(Utility.getPart(values, index.next()).getClass());
        index.previous();
        if (!($assertionsDisabled || primitive || values instanceof Object[])) {
            throw new AssertionError((Object)"");
        }
        Object[] objectArray = primitive ? (Object[])Array.newInstance(Arithmetic.class, dim) : (this.D = (Object[])values);
        while (index.hasNext()) {
            int[] i = index.next();
            Object ai = Utility.getPart(values, i);
            Utility.pre(primitive == Values.isPrimitiveWrapper(ai.getClass()), "multi-dimensional array either consistently has " + (class$orbital$math$Arithmetic == null ? ArithmeticTensor.class$("orbital.math.Arithmetic") : class$orbital$math$Arithmetic) + " or consistently contains primitive types");
            if (!primitive) continue;
            if (!$assertionsDisabled && !(ai instanceof Number)) {
                throw new AssertionError((Object)("primitive type get wrapped into instances of " + Number.class));
            }
            Utility.setPart(this.D, i, (Object)Values.getDefaultInstance().valueOf((Number)ai));
        }
    }

    private boolean checkRectangular(int[] dim, int depth, Object o) {
        if (!$assertionsDisabled && depth < dim.length != o.getClass().isArray()) {
            throw new AssertionError((Object)"by definition of rank");
        }
        if (depth >= dim.length) {
            return true;
        }
        int len = Array.getLength(o);
        if (len != dim[depth]) {
            return false;
        }
        for (int j = 0; j < len; ++j) {
            Object oj = Array.get(o, j);
            if (depth < dim.length - 1) {
                if (!$assertionsDisabled && !oj.getClass().isArray()) {
                    throw new AssertionError((Object)"by definition of rank");
                }
                if (this.checkRectangular(dim, depth + 1, oj)) continue;
                return false;
            }
            if (!$assertionsDisabled && oj.getClass().isArray()) {
                throw new AssertionError((Object)"by definition of rank");
            }
            if (o.getClass().getComponentType().isPrimitive() || (class$orbital$math$Arithmetic == null ? ArithmeticTensor.class$("orbital.math.Arithmetic") : class$orbital$math$Arithmetic).isInstance(oj)) continue;
            return false;
        }
        return true;
    }

    protected Tensor newInstance(int[] dim) {
        return new ArithmeticTensor(dim);
    }

    public final int rank() {
        return Utility.rank(this.D);
    }

    public final int[] dimensions() {
        return Utility.dimensions(this.D);
    }

    public Arithmetic get(int[] i) {
        this.validate(i);
        return (Arithmetic)Utility.getPart(this.D, i);
    }

    public void set(int[] i, Arithmetic m) {
        this.validate(i);
        Utility.setPart(this.D, i, (Object)m);
    }

    public Object clone() {
        return new ArithmeticTensor(this.toArray__Tensor());
    }

    static {
        $assertionsDisabled = !ArithmeticTensor.class.desiredAssertionStatus();
    }
}

