/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import orbital.algorithm.Combinatorical;
import orbital.logic.functor.Functionals;
import orbital.logic.functor.Predicates;
import orbital.math.Arithmetic;
import orbital.math.Polynomial;
import orbital.math.Tensor;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractMultivariatePolynomial;
import orbital.util.Setops;
import orbital.util.Utility;

class ArithmeticMultivariatePolynomial
extends AbstractMultivariatePolynomial {
    private static final long serialVersionUID = -6317707373482862125L;
    private Tensor coefficients;
    private transient int degree;

    public ArithmeticMultivariatePolynomial(int[] dimensions) {
        this.coefficients = Values.getDefaultInstance().newInstance(dimensions);
        this.CONSTANT_TERM = new int[dimensions.length];
        Arrays.fill(this.CONSTANT_TERM, 0);
    }

    public ArithmeticMultivariatePolynomial(Tensor coefficients) {
        this.set(coefficients);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.set(this.coefficients);
    }

    protected Polynomial newInstance(int[] dimensions) {
        return new ArithmeticMultivariatePolynomial(dimensions);
    }

    public final int degreeValue() {
        return this.degree;
    }

    private int degreeImpl(Tensor coefficients) {
        int d = Integer.MIN_VALUE;
        Combinatorical index = Combinatorical.getPermutations(coefficients.dimensions());
        while (index.hasNext()) {
            int sum;
            int[] i = index.next();
            Arithmetic vi = coefficients.get(i);
            if (vi == null || vi.norm().equals(Values.ZERO) || (sum = ((orbital.math.Integer)Operations.sum.apply(Values.getDefaultInstance().valueOf(i))).intValue()) <= d) continue;
            d = sum;
        }
        return d;
    }

    public Object indexSet() {
        return Values.getDefaultInstance().valueOf(this.coefficients.rank());
    }

    public int[] dimensions() {
        return this.coefficients.dimensions();
    }

    private void set(Object coefficients) {
        if (coefficients == null) {
            throw new IllegalArgumentException("illegal coefficients array: " + coefficients);
        }
        this.set(Values.getDefaultInstance().tensor(coefficients));
    }

    private void set(Tensor coefficients) {
        if (coefficients == null) {
            throw new IllegalArgumentException("illegal coefficients array: " + coefficients);
        }
        if (Setops.some(coefficients.iterator(), Functionals.bindSecond(Predicates.equal, null))) {
            throw new IllegalArgumentException("illegal coefficients: containing null");
        }
        this.coefficients = coefficients;
        this.degree = this.degreeImpl(coefficients);
        this.CONSTANT_TERM = new int[this.dimensions().length];
        Arrays.fill(this.CONSTANT_TERM, 0);
    }

    static final int[] convertIndex(Arithmetic indexAsVector) {
        Vector index = (Vector)indexAsVector;
        int[] i = new int[index.dimension()];
        for (int k = 0; k < i.length; ++k) {
            i[k] = ((orbital.math.Integer)index.get(k)).intValue();
        }
        return i;
    }

    public final Arithmetic get(Arithmetic i) {
        return this.get(ArithmeticMultivariatePolynomial.convertIndex(i));
    }

    public Arithmetic get(int[] i) {
        Utility.pre(i.length == ((orbital.math.Integer)this.indexSet()).intValue(), "illegal number of indices (" + i.length + " indices) for a coefficient of a polynomial with " + this.indexSet() + " variables");
        for (int k = 0; k < i.length; ++k) {
            if (i[k] < this.dimensions()[k]) continue;
            return this.get(this.CONSTANT_TERM).zero();
        }
        return this.coefficients.get(i);
    }

    public void set(int[] i, Arithmetic vi) {
        if (vi == null) {
            throw new IllegalArgumentException("illegal coefficient value: " + vi);
        }
        orbital.math.Integer oldDegree = this.degree();
        this.coefficients.set(i, vi);
        if (oldDegree.compareTo(Operations.sum.apply(Values.getDefaultInstance().valueOf(i))) <= 0) {
            this.degree = this.degreeImpl(this.coefficients);
        }
    }

    public final void set(Arithmetic i, Arithmetic vi) {
        this.set(ArithmeticMultivariatePolynomial.convertIndex(i), vi);
    }

    Tensor tensorViewOfCoefficients() {
        return this.coefficients;
    }
}

