/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.ListIterator;
import orbital.algorithm.Combinatorical;
import orbital.logic.functor.Function;
import orbital.logic.functor.Predicate;
import orbital.logic.functor.Predicates;
import orbital.math.Arithmetic;
import orbital.math.ArithmeticFormat;
import orbital.math.Integer;
import orbital.math.MathUtilities;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Tensor;
import orbital.math.Values;
import orbital.math.functional.Functionals;
import orbital.math.functional.Functions;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractProductArithmetic;
import orbital.moon.math.ArithmeticTensor;
import orbital.util.InnerCheckedException;
import orbital.util.Setops;
import orbital.util.Utility;

abstract class AbstractTensor
extends AbstractProductArithmetic
implements Tensor,
Serializable {
    private static final long serialVersionUID = 7889937971348824822L;
    protected transient int modCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractTensor() {
    }

    public boolean equals(Object o) {
        return o instanceof Tensor && super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException nonconform) {
            throw new InnerCheckedException("invariant: sub classes of " + Tensor.class + " must either overwrite clone() or implement " + Cloneable.class, nonconform);
        }
    }

    protected abstract Tensor newInstance(int[] var1);

    protected final Arithmetic newInstance(Object productIndexSet) {
        return this.newInstance((int[])productIndexSet);
    }

    protected Object productIndexSet(Arithmetic productObject) {
        return ((Tensor)productObject).dimensions();
    }

    protected ListIterator iterator(Arithmetic productObject) {
        return ((Tensor)productObject).iterator();
    }

    public ListIterator iterator() {
        return new ListIterator(){
            private Combinatorical cursor;
            private int[] lastRet;
            private transient int expectedModCount;
            {
                this.cursor = Combinatorical.getPermutations(AbstractTensor.this.dimensions());
                this.lastRet = null;
                this.expectedModCount = AbstractTensor.this.modCount;
            }

            public boolean hasNext() {
                return this.cursor.hasNext();
            }

            public Object next() {
                try {
                    this.lastRet = (int[])this.cursor.next().clone();
                    Arithmetic v = AbstractTensor.this.get(this.lastRet);
                    this.checkForComodification();
                    return v;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"cursor should already have thrown a NoSuchElementException"))).initCause(e));
                }
            }

            public boolean hasPrevious() {
                return this.cursor.hasPrevious();
            }

            public Object previous() {
                try {
                    this.lastRet = (int[])this.cursor.previous().clone();
                    Arithmetic v = AbstractTensor.this.get(this.lastRet);
                    this.checkForComodification();
                    return v;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"cursor should already have thrown a NoSuchElementException"))).initCause(e));
                }
            }

            public void set(Object o) {
                if (!(o instanceof Arithmetic)) {
                    throw new IllegalArgumentException();
                }
                if (this.lastRet == null) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    AbstractTensor.this.set(this.lastRet, (Arithmetic)o);
                    this.expectedModCount = AbstractTensor.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            public int nextIndex() {
                throw new UnsupportedOperationException("a tensor does not have a one-dimensional index");
            }

            public int previousIndex() {
                throw new UnsupportedOperationException("a tensor does not have a one-dimensional index");
            }

            public void add(Object o) {
                throw new UnsupportedOperationException("adding a single element from a tensor is impossible");
            }

            public void remove() {
                throw new UnsupportedOperationException("removing a single element from a tensor is impossible");
            }

            private final void checkForComodification() {
                if (AbstractTensor.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public Tensor subTensor(int[] i1, int[] i2) {
        return new SubTensor(this, i1, i2);
    }

    public Tensor subTensor(int level, int index) {
        return new PartTensor(this, level, index);
    }

    public Tensor subTensorTransposed(int[] permutation) {
        return new TransposedTensor(this, permutation);
    }

    public void setSubTensor(int level, int index, Tensor part) {
        Tensor embed = this.subTensor(level, index);
        Utility.pre(part.rank() == this.rank() - 1, "part has compatible rank");
        Utility.pre(Utility.equalsAll(part.dimensions(), embed.dimensions()), "part has compatible dimensions");
        ListIterator dst = embed.iterator();
        Setops.copy(dst, part.iterator());
        if (!$assertionsDisabled && dst.hasNext()) {
            throw new AssertionError((Object)"equal dimensions have iterators of equal length");
        }
    }

    public void setSubTensor(int[] i1, int[] i2, Tensor sub) {
        Tensor embed = this.subTensor(i1, i2);
        Utility.pre(sub.rank() == this.rank(), "sub tensor has compatible rank");
        Utility.pre(Utility.equalsAll(sub.dimensions(), embed.dimensions()), "sub tensor has compatible dimensions");
        ListIterator dst = embed.iterator();
        Setops.copy(dst, sub.iterator());
        if (!$assertionsDisabled && dst.hasNext()) {
            throw new AssertionError((Object)"equal dimensions have iterators of equal length");
        }
    }

    public Real norm() {
        return (Real)Functions.sqrt.apply(Operations.sum.apply(Functionals.map((Function)Functions.square, Functionals.map((Function)Functions.norm, this.iterator()))));
    }

    public Arithmetic zero() {
        return Values.getDefaultInstance().ZERO(this.dimensions());
    }

    public Arithmetic one() {
        throw new UnsupportedOperationException();
    }

    public Tensor add(Tensor B) {
        return (Tensor)super.add(B);
    }

    public Tensor subtract(Tensor B) {
        return (Tensor)super.subtract(B);
    }

    public Arithmetic scale(Arithmetic s) {
        return (Tensor)super.scale(s);
    }

    public Tensor multiply(Tensor b) {
        int[] dim = new int[this.rank() + b.rank() - 2];
        int[] d = this.dimensions();
        int[] e = b.dimensions();
        int conv = d.length - 1;
        int len = d[conv];
        if (d[conv] != e[0]) {
            throw new IllegalArgumentException("inner product a.b only defined for dimension n1 x ... x nr x n multiplied with n x m1 x ... x mr, but not for " + MathUtilities.format(this.dimensions()) + " with " + MathUtilities.format(b.dimensions()));
        }
        System.arraycopy(d, 0, dim, 0, conv);
        System.arraycopy(e, 1, dim, conv, e.length - 1);
        Tensor ret = this.newInstance(dim);
        Combinatorical index = Combinatorical.getPermutations(dim);
        while (index.hasNext()) {
            int[] ij = index.next();
            Arithmetic s = Values.ZERO;
            int nu = 0;
            while (nu < len) {
                int[] i = new int[d.length];
                System.arraycopy(ij, 0, i, 0, conv);
                i[conv] = nu;
                int[] j = new int[e.length];
                j[0] = nu++;
                System.arraycopy(ij, conv, j, 1, e.length - 1);
                s = s.add(this.get(i).multiply(b.get(j)));
            }
            ret.set(ij, s);
        }
        return ret;
    }

    public Tensor tensor(Tensor b) {
        return (Tensor)super.scale(b);
    }

    public Arithmetic add(Arithmetic b) {
        return this.add((Tensor)b);
    }

    public Arithmetic subtract(Arithmetic b) {
        return this.subtract((Tensor)b);
    }

    public Arithmetic multiply(Arithmetic b) {
        if (b instanceof Scalar) {
            return this.scale((Scalar)b);
        }
        if (b instanceof Tensor) {
            return this.multiply((Tensor)b);
        }
        throw new IllegalArgumentException("wrong type " + b.getClass());
    }

    public Arithmetic inverse() throws ArithmeticException {
        throw new UnsupportedOperationException();
    }

    final void validate(int[] i) {
        if (i.length != this.rank()) {
            throw new ArrayIndexOutOfBoundsException("illegal number of indices (" + i.length + " indices) for tensor of rank " + this.rank());
        }
        int[] dim = this.dimensions();
        for (int k = 0; k < i.length; ++k) {
            if (i[k] < 0) {
                throw new ArrayIndexOutOfBoundsException(k + "-th index (" + i[k] + ") is negative");
            }
            if (i[k] < dim[k]) continue;
            throw new ArrayIndexOutOfBoundsException(k + "-th index (" + i[k] + ") out of dimension (" + dim[k] + ")");
        }
    }

    public String toString() {
        return ArithmeticFormat.getDefaultInstance().format(this);
    }

    public Object[] toArray__Tensor() {
        int[] dim = this.dimensions();
        Object[] r = (Object[])Array.newInstance(Arithmetic.class, dim);
        Combinatorical index = Combinatorical.getPermutations(this.dimensions());
        while (index.hasNext()) {
            int[] i = index.next();
            Utility.setPart(r, i, (Object)this.get(i));
        }
        return r;
    }

    static {
        $assertionsDisabled = !AbstractTensor.class.desiredAssertionStatus();
    }

    private static class TransposedTensor
    extends TransformedAccessTensor {
        private static final long serialVersionUID = 590361721474800306L;
        private final int[] permutation;

        public TransposedTensor(AbstractTensor m, int[] permutation) {
            super(m);
            Utility.pre(permutation.length == m.rank(), "indices must be of correct rank.");
            Utility.pre(Setops.all(Values.getDefaultInstance().valueOf(permutation).iterator(), new Predicate(this, m){
                private final /* synthetic */ AbstractTensor val$m;
                private final /* synthetic */ TransposedTensor this$0;
                {
                    this.this$0 = this$0;
                    this.val$m = val$m;
                }

                public boolean apply(Object o) {
                    return o instanceof Integer && MathUtilities.isin(((Integer)o).intValue(), 0, this.val$m.rank() - 1);
                }
            }), "The mapping table of a permutation in S_n contains the integers {0,...,n-1}.");
            Utility.pre(new HashSet(Setops.asList(Values.getDefaultInstance().valueOf(permutation).iterator())).size() == m.rank(), "A permutation is bijective, so its mapping table should not contain duplicates.");
            this.permutation = permutation;
        }

        public final int[] dimensions() {
            this.checkForComodification();
            return this.transformIndex(this.getDelegatee().dimensions());
        }

        protected int[] transformIndex(int[] i) {
            int[] itranslated = new int[i.length];
            for (int k = 0; k < i.length; ++k) {
                itranslated[k] = i[this.permutation[k]];
            }
            return itranslated;
        }
    }

    private static class PartTensor
    extends TransformedAccessTensor {
        private static final long serialVersionUID = 4545087879048756777L;
        private final int level;
        private final int index;

        public PartTensor(AbstractTensor m, int level, int index) {
            super(m);
            Utility.pre(0 <= level && level < m.rank(), "level is within the rank");
            Utility.pre(0 <= index && index < m.dimensions()[level], "index is within the dimensions");
            this.level = level;
            this.index = index;
        }

        public int rank() {
            return this.getDelegatee().rank() - 1;
        }

        public final int[] dimensions() {
            this.checkForComodification();
            int[] dim = this.getDelegatee().dimensions();
            int[] dimTranslated = new int[dim.length - 1];
            System.arraycopy(dim, 0, dimTranslated, 0, this.level);
            System.arraycopy(dim, this.level + 1, dimTranslated, this.level, dim.length - (this.level + 1));
            return dimTranslated;
        }

        protected final int[] transformIndex(int[] i) {
            int[] itranslated = new int[i.length + 1];
            System.arraycopy(i, 0, itranslated, 0, this.level);
            itranslated[this.level] = this.index;
            System.arraycopy(i, this.level, itranslated, this.level + 1, i.length - this.level);
            return itranslated;
        }
    }

    private static class SubTensor
    extends TransformedAccessTensor {
        private static final long serialVersionUID = -8431476748988993108L;
        private final int[] offset;
        private final int[] dim;

        public SubTensor(AbstractTensor m, int[] i1, int[] i2) {
            super(m);
            Utility.pre(i1.length == m.rank() && i2.length == m.rank(), "indices must be of correct rank.");
            Utility.pre(Setops.all(Values.getDefaultInstance().valueOf(i1).iterator(), Values.getDefaultInstance().valueOf(i2).iterator(), Predicates.lessEqual), "Ending indices cannot be less than starting indices.");
            m.validate(i1);
            m.validate(i2);
            this.offset = i1;
            this.dim = new int[i1.length];
            for (int k = 0; k < this.dim.length; ++k) {
                this.dim[k] = i2[k] - i1[k] + 1;
            }
        }

        public final int[] dimensions() {
            this.checkForComodification();
            return (int[])this.dim.clone();
        }

        protected int[] transformIndex(int[] i) {
            int[] itranslated = new int[i.length];
            for (int k = 0; k < i.length; ++k) {
                itranslated[k] = this.offset[k] + i[k];
            }
            return itranslated;
        }
    }

    static abstract class TransformedAccessTensor
    extends AbstractTensor {
        private static final long serialVersionUID = -3609507213928180122L;
        private final AbstractTensor m;
        private transient int expectedModCount = 0;

        protected TransformedAccessTensor(AbstractTensor m) {
            this.m = m;
            this.expectedModCount = m.modCount;
        }

        protected final AbstractTensor getDelegatee() {
            return this.m;
        }

        protected abstract int[] transformIndex(int[] var1);

        protected Tensor newInstance(int[] dimensions) {
            this.checkForComodification();
            return this.m.newInstance(dimensions);
        }

        public int rank() {
            return this.m.rank();
        }

        public int[] dimensions() {
            this.checkForComodification();
            return this.m.dimensions();
        }

        public Arithmetic get(int[] i) {
            this.validate(i);
            this.checkForComodification();
            return this.m.get(this.transformIndex(i));
        }

        public void set(int[] i, Arithmetic mi) {
            this.validate(i);
            this.checkForComodification();
            this.m.set(this.transformIndex(i), mi);
        }

        public Object clone() {
            this.checkForComodification();
            return new ArithmeticTensor(super.toArray__Tensor());
        }

        protected final void checkForComodification() {
            if (this.m.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

