/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.math.BigDecimal;
import orbital.math.Arithmetic;
import orbital.math.Complex;
import orbital.math.Real;
import orbital.math.Values;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractComplex;

abstract class AbstractReal
extends AbstractComplex
implements Real {
    private static final long serialVersionUID = -4117614439306224843L;

    protected AbstractReal() {
    }

    public boolean equals(Object o) {
        if (Real.isa.apply(o)) {
            return java.lang.Double.doubleToLongBits(this.doubleValue()) == java.lang.Double.doubleToLongBits(((Real)o).doubleValue());
        }
        return super.equals(o);
    }

    public int hashCode() {
        long bits = java.lang.Double.doubleToLongBits(this.doubleValue());
        return (int)(bits ^ bits >>> 32);
    }

    public Real norm() {
        return Values.getDefaultInstance().valueOf(Math.abs(this.doubleValue()));
    }

    public int compareTo(Object o) {
        return this.compareToImpl(o);
    }

    final int compareToImpl(Object o) {
        return AbstractReal.compare(this.doubleValue(), ((Real)o).doubleValue());
    }

    private static int compare(double d1, double d2) {
        long anotherBits;
        if (d1 < d2) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        long thisBits = java.lang.Double.doubleToLongBits(d1);
        return thisBits == (anotherBits = java.lang.Double.doubleToLongBits(d2)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }

    public Arithmetic add(Arithmetic b) {
        if (b instanceof Real) {
            return this.add((Real)b);
        }
        return (Arithmetic)Operations.plus.apply(this, b);
    }

    public Arithmetic subtract(Arithmetic b) {
        if (b instanceof Real) {
            return this.subtract((Real)b);
        }
        return (Arithmetic)Operations.subtract.apply(this, b);
    }

    public Arithmetic multiply(Arithmetic b) {
        if (b instanceof Real) {
            return this.multiply((Real)b);
        }
        return (Arithmetic)Operations.times.apply(this, b);
    }

    public Arithmetic divide(Arithmetic b) {
        if (b instanceof Real) {
            return this.divide((Real)b);
        }
        return (Arithmetic)Operations.divide.apply(this, b);
    }

    public Arithmetic power(Arithmetic b) {
        if (b instanceof Real) {
            return this.power((Real)b);
        }
        return (Arithmetic)Operations.power.apply(this, b);
    }

    public final Real re() {
        return this;
    }

    final double realValue() {
        return this.doubleValue();
    }

    public final Real im() {
        return Values.ZERO;
    }

    final double imaginaryValue() {
        return 0.0;
    }

    public final Complex conjugate() {
        return this;
    }

    public Complex add(Complex b) {
        return (Complex)Operations.plus.apply(this, b);
    }

    public Complex subtract(Complex b) {
        return (Complex)Operations.subtract.apply(this, b);
    }

    public Complex multiply(Complex b) {
        return (Complex)Operations.times.apply(this, b);
    }

    public Complex divide(Complex b) {
        return (Complex)Operations.divide.apply(this, b);
    }

    static class Big
    extends AbstractReal {
        private static final long serialVersionUID = -5801439569926611104L;
        private static final int ROUNDING_MODE = 6;
        private BigDecimal value;

        public Big(double v) {
            this(new BigDecimal(v));
        }

        public Big(BigDecimal v) {
            this.value = v;
        }

        public Object clone() {
            return new Big(new BigDecimal(this.value.unscaledValue(), this.value.scale()));
        }

        public double doubleValue() {
            return this.value.doubleValue();
        }

        public Real add(Real b) {
            return new Big(this.value.add(((Big)b).value));
        }

        public Real subtract(Real b) {
            return new Big(this.value.subtract(((Big)b).value));
        }

        public Arithmetic minus() {
            return new Big(this.value.negate());
        }

        public Real multiply(Real b) {
            return new Big(this.value.multiply(((Big)b).value));
        }

        public Real divide(Real b) {
            return new Big(this.value.divide(((Big)b).value, 6));
        }

        public Real power(Real b) {
            throw new InternalError("not yet implemented");
        }

        public Arithmetic inverse() {
            return this.one().divide(this);
        }

        public Arithmetic add(Arithmetic b) {
            if (b instanceof Real) {
                return this.add((Real)b);
            }
            return super.add(b);
        }

        public Arithmetic subtract(Arithmetic b) {
            if (b instanceof Real) {
                return this.subtract((Real)b);
            }
            return super.subtract(b);
        }

        public Arithmetic multiply(Arithmetic b) {
            if (b instanceof Real) {
                return this.multiply((Real)b);
            }
            return super.multiply(b);
        }

        public Arithmetic divide(Arithmetic b) {
            if (b instanceof Real) {
                return this.divide((Real)b);
            }
            return super.divide(b);
        }

        public Arithmetic power(Arithmetic b) {
            if (b instanceof Real) {
                return this.power((Real)b);
            }
            return super.power(b);
        }
    }

    static class Double
    extends AbstractReal {
        private static final long serialVersionUID = 2011638443547790678L;
        private double value;

        public Double(double v) {
            this.value = v;
        }

        public Double(Number v) {
            this.value = v.doubleValue();
        }

        public Object clone() {
            return new Double(this.doubleValue());
        }

        public double doubleValue() {
            return this.value;
        }

        public Real add(Real b) {
            return new Double(this.doubleValue() + b.doubleValue());
        }

        public Real subtract(Real b) {
            return new Double(this.doubleValue() - b.doubleValue());
        }

        public Arithmetic minus() {
            return new Double(-this.doubleValue());
        }

        public Real multiply(Real b) {
            return new Double(this.doubleValue() * b.doubleValue());
        }

        public Real divide(Real b) {
            return new Double(this.doubleValue() / b.doubleValue());
        }

        public Real power(Real b) {
            return new Double(Math.pow(this.doubleValue(), b.doubleValue()));
        }

        public Arithmetic inverse() {
            return new Double(1.0 / this.doubleValue());
        }

        public Arithmetic add(Arithmetic b) {
            if (b instanceof Real) {
                return this.add((Real)b);
            }
            return super.add(b);
        }

        public Arithmetic subtract(Arithmetic b) {
            if (b instanceof Real) {
                return this.subtract((Real)b);
            }
            return super.subtract(b);
        }

        public Arithmetic multiply(Arithmetic b) {
            if (b instanceof Real) {
                return this.multiply((Real)b);
            }
            return super.multiply(b);
        }

        public Arithmetic divide(Arithmetic b) {
            if (b instanceof Real) {
                return this.divide((Real)b);
            }
            return super.divide(b);
        }

        public Arithmetic power(Arithmetic b) {
            if (b instanceof Real) {
                return this.power((Real)b);
            }
            return super.power(b);
        }
    }

    static class Float
    extends AbstractReal {
        private static final long serialVersionUID = -206414766833581552L;
        private float value;

        public Float(float v) {
            this.value = v;
        }

        public Float(Number v) {
            this.value = v.floatValue();
        }

        public Object clone() {
            return new Float(this.floatValue());
        }

        public float floatValue() {
            return this.value;
        }

        public double doubleValue() {
            return this.value;
        }

        public Real add(Real b) {
            if (b instanceof Float) {
                return new Float(this.floatValue() + b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)this.floatValue() + b.doubleValue());
            }
            return (Real)Operations.plus.apply(this, b);
        }

        public Real subtract(Real b) {
            if (b instanceof Float) {
                return new Float(this.floatValue() - b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)this.floatValue() - b.doubleValue());
            }
            return (Real)Operations.subtract.apply(this, b);
        }

        public Arithmetic minus() {
            return new Float(-this.floatValue());
        }

        public Real multiply(Real b) {
            if (b instanceof Float) {
                return new Float(this.floatValue() * b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)this.floatValue() * b.doubleValue());
            }
            return (Real)Operations.times.apply(this, b);
        }

        public Real divide(Real b) {
            if (b instanceof Float) {
                return new Float(this.floatValue() / b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)this.floatValue() / b.doubleValue());
            }
            return (Real)Operations.divide.apply(this, b);
        }

        public Real power(Real b) {
            if (b instanceof Float) {
                return new Float((float)Math.pow(this.floatValue(), b.floatValue()));
            }
            if (b instanceof Double) {
                return new Double(Math.pow(this.floatValue(), b.doubleValue()));
            }
            return (Real)Operations.power.apply(this, b);
        }

        public Arithmetic inverse() {
            return new Float(1.0f / this.floatValue());
        }
    }
}

