/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.awt;

import java.applet.AudioClip;
import java.net.URL;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;

class AudioSystemAudioClip
implements AudioClip {
    private URL url;
    private Clip clip = null;
    private Sequencer sequencer = null;

    public AudioSystemAudioClip(URL url) {
        this.url = url;
    }

    protected void init(URL url) throws Exception {
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(url);
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(stream);
        }
        catch (Exception alternative) {
            Sequence sequence = MidiSystem.getSequence(url);
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
            this.sequencer.setSequence(sequence);
        }
    }

    private boolean opened() {
        if (this.clip == null && this.sequencer == null) {
            try {
                this.init(this.url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.clip != null || this.sequencer != null;
    }

    public void play() {
        if (this.opened()) {
            if (this.clip != null) {
                this.clip.start();
            } else {
                this.sequencer.start();
            }
        }
    }

    public void loop() {
        if (this.opened()) {
            if (this.clip != null) {
                this.clip.loop(-1);
            } else {
                throw new UnsupportedOperationException("midi does not support loop");
            }
        }
    }

    public void stop() {
        if (this.opened()) {
            if (this.clip != null) {
                this.clip.stop();
            } else {
                this.sequencer.stop();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.clip != null) {
            this.clip.close();
        }
        if (this.sequencer != null) {
            this.sequencer.close();
        }
    }
}

