/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import orbital.algorithm.Combinatorical;
import orbital.logic.functor.Functionals;
import orbital.logic.functor.Predicates;
import orbital.math.AlgebraicAlgorithms;
import orbital.math.Arithmetic;
import orbital.math.Complex;
import orbital.math.ExpectationHurtParseException;
import orbital.math.Fraction;
import orbital.math.Integer;
import orbital.math.MathUtilities;
import orbital.math.Matrix;
import orbital.math.Polynomial;
import orbital.math.Quotient;
import orbital.math.Rational;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Symbol;
import orbital.math.Tensor;
import orbital.math.UnivariatePolynomial;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.MathFunctor;
import orbital.util.Setops;

public class ArithmeticFormat
extends Format {
    private static final Logger logger;
    private static final long serialVersionUID = 4708045695735837065L;
    public static final int NUMERATOR_FIELD = 2;
    public static final int DENOMINATOR_FIELD = 3;
    public static final int REAL_FIELD = 4;
    public static final int IMAGINARY_FIELD = 5;
    public static final int SYMBOL_FIELD = 10;
    private NumberFormat numberFormat;
    private String rationalSeparator = "/";
    private String complexPositiveSeparator = "+";
    private String complexNegativeSeparator = "-";
    private boolean complexUnitLast = false;
    private String complexUnit = "i";
    private String complexUnitSeparator = "*";
    private boolean complexAbbreviateNullReal = true;
    private boolean complexAbbreviateNullImaginary = true;
    private boolean complexAbbreviateOne = true;
    private boolean complexAbbreviateNullRealPositiveSeparator = true;
    private String vectorPrefix = "(";
    private String vectorSeparator = ",";
    private String[] vectorSeparatorAlternatives = new String[]{"\t", "|"};
    private String vectorSuffix = ")";
    private String matrixPrefix = "";
    private String matrixSeparator = ",\t";
    private String[] matrixSeparatorAlternatives = new String[]{",", "\t"};
    private String matrixSuffix = "";
    private String matrixRowPrefix = "[";
    private String matrixRowSeparator = System.getProperty("line.separator");
    private String[] matrixRowSeparatorAlternatives = new String[]{"\n", "\r\n", ";", " ", "\t", ""};
    private String matrixRowSuffix = "]";
    private String polynomialPrefix = "";
    private String polynomialTimesOperator = "";
    private String polynomialVariable = "X";
    private String polynomialPowerOperator = "^";
    private String polynomialPlusOperator = "+";
    private String polynomialPlusAlternative = "-";
    private String polynomialSuffix = "";
    private String multinomialPrefix = "";
    private String multinomialTimesOperator = "*";
    private String multinomialVariableTimesOperator = "*";
    private String[] multinomialVariables = new String[]{"X", "Y", "Z"};
    private String multinomialPowerOperator = "^";
    private String multinomialPlusOperator = "+";
    private String multinomialPlusAlternative = "-";
    private String multinomialSuffix = "";
    private static final ArithmeticFormat defaultFormat;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ArithmeticFormat(Locale locale) {
        this.numberFormat = NumberFormat.getNumberInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMaximumFractionDigits(MathUtilities.getDefaultPrecisionDigits());
    }

    public static ArithmeticFormat getInstance(Locale locale) {
        return new ArithmeticFormat(locale);
    }

    public static ArithmeticFormat getInstance() {
        return new ArithmeticFormat(Locale.getDefault());
    }

    public static final ArithmeticFormat getDefaultInstance() {
        return defaultFormat;
    }

    public String getPolynomialVariable() {
        return this.polynomialVariable;
    }

    public void setPolynomialVariable(String polynomialVariable) {
        this.polynomialVariable = polynomialVariable;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    protected void setNumberFormat(NumberFormat newNumberFormat) {
        this.numberFormat = newNumberFormat;
    }

    public String format(Arithmetic obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Scalar obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Tensor obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Vector obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Matrix obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Complex obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Real obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Rational obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Integer obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Polynomial obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(UnivariatePolynomial obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Quotient obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Fraction obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Symbol obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(MathFunctor obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public StringBuffer format(Object obj, StringBuffer result, FieldPosition fieldPosition) {
        if (obj == null) {
            return new StringBuffer("null");
        }
        if (obj instanceof Arithmetic) {
            return this.format((Arithmetic)obj, result, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as an arithmetic object: " + obj.getClass());
    }

    public StringBuffer format(Arithmetic obj, StringBuffer result, FieldPosition fieldPosition) {
        if (obj == null) {
            return new StringBuffer("null");
        }
        if (obj instanceof Scalar) {
            return this.format((Scalar)obj, result, fieldPosition);
        }
        if (obj instanceof Tensor) {
            return this.format((Tensor)obj, result, fieldPosition);
        }
        if (obj instanceof Polynomial) {
            return this.format((Polynomial)obj, result, fieldPosition);
        }
        if (obj instanceof Symbol) {
            return this.format((Symbol)obj, result, fieldPosition);
        }
        if (obj instanceof Fraction) {
            return this.format((Fraction)obj, result, fieldPosition);
        }
        if (obj instanceof Quotient) {
            return this.format((Quotient)obj, result, fieldPosition);
        }
        if (obj instanceof MathFunctor) {
            return this.format((MathFunctor)obj, result, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as an arithmetic object: " + obj.getClass());
    }

    public StringBuffer format(Scalar obj, StringBuffer result, FieldPosition fieldPosition) {
        if (Complex.hasType.apply(obj)) {
            return this.format((Complex)obj, result, fieldPosition);
        }
        if (Real.hasType.apply(obj)) {
            return this.format((Real)obj, result, fieldPosition);
        }
        if (Rational.hasType.apply(obj)) {
            return this.format((Rational)obj, result, fieldPosition);
        }
        if (Integer.hasType.apply(obj)) {
            return this.format((Integer)obj, result, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as an arithmetic object");
    }

    public StringBuffer format(Tensor obj, StringBuffer result, FieldPosition fieldPosition) {
        int k;
        if (obj == null) {
            return new StringBuffer("null");
        }
        if (obj instanceof Vector) {
            return this.format((Vector)obj, result, fieldPosition);
        }
        if (obj instanceof Matrix) {
            return this.format((Matrix)obj, result, fieldPosition);
        }
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        obj = AlgebraicAlgorithms.flatten(obj);
        int[] permutation = new int[obj.rank()];
        int c = 0;
        for (k = 0; k < permutation.length; k += 2) {
            permutation[k] = c++;
        }
        for (k = 1; k < permutation.length; k += 2) {
            permutation[k] = c++;
        }
        obj = obj.subTensorTransposed(permutation);
        result.append(this.matrixPrefix);
        int[] lasti = null;
        Combinatorical index = Combinatorical.getPermutations(obj.dimensions());
        while (index.hasNext()) {
            int[] i = index.next();
            if (lasti == null) {
                result.append(this.matrixRowPrefix);
                result.append("{");
            } else {
                int numberOfCompleted = 0;
                for (int k2 = i.length - 1; k2 >= 0; --k2) {
                    if (i[k2] != 0 || lasti[k2] == false) continue;
                    ++numberOfCompleted;
                }
                if (numberOfCompleted > 0) {
                    result.append("}");
                }
                for (int colAndRowsFinished = 2; colAndRowsFinished < numberOfCompleted; ++colAndRowsFinished) {
                    result.append("]\n[\t");
                }
                if (numberOfCompleted >= (int)Math.floor((double)i.length / 2.0)) {
                    result.append(this.matrixRowSuffix);
                    result.append(this.matrixRowSeparator);
                    result.append(this.matrixRowPrefix);
                } else {
                    result.append(this.matrixSeparator);
                }
                if (numberOfCompleted > 0) {
                    result.append("{");
                }
            }
            this.format(obj.get(i), result, fieldPosition);
            lasti = (int[])i.clone();
        }
        result.append("}");
        result.append(this.matrixRowSuffix);
        result.append(this.matrixSuffix);
        return result;
    }

    public StringBuffer format(Vector v, StringBuffer result, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        result.append(this.vectorPrefix);
        ListIterator i = v.iterator();
        while (i.hasNext()) {
            this.format(i.next(), result, fieldPosition);
            if (!i.hasNext()) continue;
            result.append(this.vectorSeparator);
        }
        result.append(this.vectorSuffix);
        return result;
    }

    public StringBuffer format(Matrix v, StringBuffer result, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        result.append(this.matrixPrefix);
        for (int i = 0; i < v.dimension().height; ++i) {
            if (i != 0) {
                result.append(this.matrixRowSeparator);
            }
            result.append(this.matrixRowPrefix);
            for (int j = 0; j < v.dimension().width; ++j) {
                if (j != 0) {
                    result.append(this.matrixSeparator);
                }
                this.format(v.get(i, j), result, fieldPosition);
            }
            result.append(this.matrixRowSuffix);
        }
        result.append(this.matrixSuffix);
        return result;
    }

    public StringBuffer format(Complex v, StringBuffer result, FieldPosition fieldPosition) {
        if (!Complex.hasType.apply(v)) {
            return this.format((Scalar)v, result, fieldPosition);
        }
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        if (fieldPosition.getField() == 4) {
            fieldPosition.setBeginIndex(result.length());
        }
        Real re = v.re();
        Real im = v.im();
        if (!re.equals(Values.ZERO) || this.complexAbbreviateNullReal && im.equals(Values.ZERO)) {
            this.format(re, result, fieldPosition);
        }
        if (fieldPosition.getField() == 4) {
            fieldPosition.setEndIndex(result.length());
        } else if (fieldPosition.getField() == 5) {
            fieldPosition.setBeginIndex(result.length());
        }
        if (!this.complexAbbreviateNullImaginary || !im.equals(Values.ZERO)) {
            boolean negative;
            boolean bl = negative = im.compareTo(Values.ZERO) < 0;
            if (negative) {
                im = (Real)im.minus();
                result.append(this.complexNegativeSeparator);
            } else if (!this.complexAbbreviateNullRealPositiveSeparator || !re.equals(Values.ZERO)) {
                result.append(this.complexPositiveSeparator);
            }
            if (!this.complexUnitLast) {
                result.append(this.complexUnit);
            }
            if (!this.complexAbbreviateOne || !im.norm().equals(Values.ONE)) {
                if (!this.complexUnitLast) {
                    result.append(this.complexUnitSeparator);
                }
                this.format(im, result, fieldPosition);
                if (this.complexUnitLast) {
                    result.append(this.complexUnitSeparator);
                }
            }
            if (this.complexUnitLast) {
                result.append(this.complexUnit);
            }
        }
        if (fieldPosition.getField() == 5) {
            fieldPosition.setEndIndex(result.length());
        }
        return result;
    }

    public StringBuffer format(Real v, StringBuffer result, FieldPosition fieldPosition) {
        if (!Real.hasType.apply(v)) {
            return this.format((Scalar)v, result, fieldPosition);
        }
        return this.numberFormat.format(v.doubleValue(), result, fieldPosition);
    }

    public StringBuffer format(Rational v, StringBuffer result, FieldPosition fieldPosition) {
        if (!Rational.hasType.apply(v)) {
            return this.format((Scalar)v, result, fieldPosition);
        }
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        if (fieldPosition.getField() == 2 || fieldPosition.getField() == 4) {
            fieldPosition.setBeginIndex(result.length());
        }
        this.numberFormat.format(v.numerator(), result, fieldPosition);
        if (fieldPosition.getField() == 2) {
            fieldPosition.setEndIndex(result.length());
        } else if (fieldPosition.getField() == 3) {
            fieldPosition.setBeginIndex(result.length());
        }
        if (logger.isLoggable(Level.FINER) || !v.denominator().equals(Values.ONE)) {
            result.append(this.rationalSeparator);
            this.numberFormat.format(v.denominator(), result, fieldPosition);
        }
        if (fieldPosition.getField() == 3 || fieldPosition.getField() == 4) {
            fieldPosition.setEndIndex(result.length());
        }
        return result;
    }

    public StringBuffer format(Integer v, StringBuffer result, FieldPosition fieldPosition) {
        if (!Integer.hasType.apply(v)) {
            return this.format((Scalar)v, result, fieldPosition);
        }
        return this.numberFormat.format(v.longValue(), result, fieldPosition);
    }

    public StringBuffer format(Polynomial p, StringBuffer result, FieldPosition fieldPosition) {
        if (p instanceof UnivariatePolynomial) {
            return this.format((UnivariatePolynomial)p, result, fieldPosition);
        }
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        int initialIndex = result.length();
        boolean addIndex = ((Integer)p.indexSet()).intValue() > this.multinomialVariables.length;
        result.append(this.multinomialPrefix);
        Iterator index = p.indices();
        while (index.hasNext()) {
            boolean skipped;
            Vector i = (Vector)index.next();
            Arithmetic ci = p.get(i);
            boolean constantTerm = Setops.all(i.iterator(), Functionals.bindSecond(Predicates.equal, (Object)Values.ZERO));
            if (ci.norm().equals(Values.ZERO) && (!constantTerm || p.degreeValue() > 0)) continue;
            int startIndex = result.length();
            if (ci.equals(ci.one()) && !constantTerm) {
                skipped = true;
            } else if (ci.equals(ci.one().minus()) && !constantTerm) {
                result.append(this.multinomialPlusAlternative);
                skipped = true;
            } else {
                result.append(ci);
                skipped = false;
            }
            if (!(startIndex <= initialIndex || result.length() > startIndex && result.substring(startIndex).startsWith(this.multinomialPlusAlternative))) {
                result.insert(startIndex, this.multinomialPlusOperator);
            }
            boolean firstVariableAfterCoefficient = true;
            int countk = 0;
            ListIterator k = i.iterator();
            while (k.hasNext()) {
                Integer exponent = (Integer)k.next();
                if (!exponent.equals(Values.ZERO)) {
                    if (firstVariableAfterCoefficient) {
                        if (!skipped) {
                            result.append(this.multinomialTimesOperator);
                        }
                    } else {
                        result.append(this.multinomialVariableTimesOperator);
                    }
                    result.append(addIndex ? this.multinomialVariables[0] + countk : this.multinomialVariables[countk]);
                    if (exponent.compareTo(Values.ONE) > 0) {
                        result.append(this.multinomialPowerOperator + exponent);
                    }
                    firstVariableAfterCoefficient = false;
                }
                ++countk;
            }
        }
        result.append(this.multinomialSuffix);
        return result;
    }

    public StringBuffer format(UnivariatePolynomial p, StringBuffer result, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        int initialIndex = result.length();
        result.append(this.polynomialPrefix);
        for (int i = Math.max(p.degreeValue(), 0); i >= 0; --i) {
            boolean skipped;
            Arithmetic ci = p.get(i);
            if (ci.norm().equals(Values.ZERO) && (i != 0 || result.length() != initialIndex)) continue;
            int startIndex = result.length();
            if (ci.equals(ci.one()) && i != 0) {
                skipped = true;
            } else if (ci.equals(ci.one().minus()) && i != 0) {
                result.append(this.polynomialPlusAlternative);
                skipped = true;
            } else {
                this.format(ci, result, fieldPosition);
                skipped = false;
            }
            if (!(i >= p.degreeValue() || result.length() > startIndex && result.substring(startIndex).startsWith(this.polynomialPlusAlternative))) {
                result.insert(startIndex, this.polynomialPlusOperator);
            }
            if (i == 0) continue;
            if (!skipped) {
                result.append(this.polynomialTimesOperator);
            }
            result.append(this.polynomialVariable);
            if (i <= 1) continue;
            result.append(this.polynomialPowerOperator + i);
        }
        result.append(this.polynomialSuffix);
        return result;
    }

    public StringBuffer format(Quotient q, StringBuffer result, FieldPosition fieldPosition) {
        result.append(((Object)q.representative()).toString());
        return result;
    }

    public StringBuffer format(Fraction as, StringBuffer result, FieldPosition fieldPosition) {
        result.append("(" + as.numerator() + ") / (" + as.denominator() + ")");
        return result;
    }

    public StringBuffer format(Symbol s, StringBuffer result, FieldPosition fieldPosition) {
        if (fieldPosition.getField() == 10) {
            fieldPosition.setBeginIndex(result.length());
        }
        result.append(s.getSignifier());
        if (fieldPosition.getField() == 10) {
            fieldPosition.setEndIndex(result.length());
        }
        return result;
    }

    public StringBuffer format(MathFunctor f, StringBuffer result, FieldPosition fieldPosition) {
        return result.append("" + f);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Arithmetic parse(String source, ParsePosition status) {
        int initialIndex = status.getIndex();
        Values vf = Values.getDefaultInstance();
        try {
            while (true) {
                Number n;
                block39: {
                    if (source.startsWith(this.matrixPrefix, status.getIndex()) && source.startsWith(this.matrixRowPrefix, status.getIndex() + this.matrixPrefix.length())) {
                        status.setIndex(status.getIndex() + this.matrixPrefix.length());
                        int colWidth = 0;
                        LinkedList<void> rows = new LinkedList<void>();
                        LinkedList linkedList = new LinkedList();
                        while (this.found(this.matrixRowPrefix, source, status)) {
                            void var7_14;
                            Arithmetic el;
                            while ((el = this.parse(source, status)) != null) {
                                var7_14.add(el);
                                if (this.found(this.matrixSeparator, source, status) || this.found(this.matrixSeparatorAlternatives, source, status)) continue;
                            }
                            this.consume(this.matrixRowSuffix, source, status);
                            rows.add(var7_14);
                            if (var7_14.size() > colWidth) {
                                colWidth = var7_14.size();
                            }
                            ArrayList arrayList = new ArrayList(colWidth);
                            if (this.found(this.matrixRowSeparator, source, status) || this.found(this.matrixRowSeparatorAlternatives, source, status)) continue;
                            break;
                        }
                        this.consume(this.matrixSuffix, source, status);
                        Matrix v = vf.newInstance(rows.size(), colWidth);
                        for (int i = 0; i < v.dimension().height; ++i) {
                            List list = (List)rows.get(i);
                            for (int j = 0; j < v.dimension().width; ++j) {
                                v.set(i, j, j < list.size() ? (Arithmetic)list.get(j) : Values.ZERO);
                            }
                        }
                        return v;
                    }
                    if (this.found(this.vectorPrefix, source, status)) {
                        Arithmetic el;
                        LinkedList<Arithmetic> components = new LinkedList<Arithmetic>();
                        while ((el = this.parse(source, status)) != null) {
                            components.add(el);
                            if (this.found(this.vectorSeparator, source, status) || this.found(this.vectorSeparatorAlternatives, source, status)) continue;
                        }
                        this.consume(this.vectorSuffix, source, status);
                        Vector vector = vf.newInstance(components.size());
                        for (int i = 0; i < vector.dimension(); ++i) {
                            vector.set(i, (Arithmetic)components.get(i));
                        }
                        return vector;
                    }
                    if (source.indexOf(this.complexUnit, status.getIndex()) < 0) break block39;
                    int fallbackIndex = status.getIndex();
                    try {
                        void var7_25;
                        void var7_20;
                        Real re = null;
                        Object var7_19 = null;
                        boolean imaginaryPart = false;
                        int sign = 1;
                        Real val = null;
                        while ((re == null || var7_20 == null) && status.getIndex() < source.length()) {
                            boolean allowUnitNumberSuffix;
                            block40: {
                                block41: {
                                    allowUnitNumberSuffix = false;
                                    if (val == null) {
                                        val = ArithmeticFormat.realValueOf(this.numberFormat.parse(source, status));
                                    }
                                    if (imaginaryPart) break block40;
                                    if (val != null && this.found(this.complexUnitSeparator, source, status) && this.found(this.complexUnit, source, status)) break block41;
                                    allowUnitNumberSuffix = this.found(this.complexUnitSeparator, source, status);
                                    if (!(this.found(this.complexUnit, source, status) | allowUnitNumberSuffix)) break block40;
                                }
                                if (var7_20 != null) {
                                    throw new NumberFormatException("no two imaginary parts");
                                }
                                imaginaryPart = true;
                            }
                            if (allowUnitNumberSuffix && val == null) {
                                val = ArithmeticFormat.realValueOf(this.numberFormat.parse(source, status));
                            }
                            if (val != null) {
                                val = vf.valueOf((double)sign * val.doubleValue());
                                if (imaginaryPart) {
                                    if (var7_20 != null) throw new NumberFormatException("no two imaginary parts");
                                    Real real = val;
                                } else {
                                    if (re != null) throw new NumberFormatException("no two real parts");
                                    re = val;
                                }
                                val = null;
                                imaginaryPart = false;
                                sign = 1;
                                continue;
                            }
                            if (this.found("+", source, status)) {
                                if (!$assertionsDisabled && val != null) {
                                    throw new AssertionError((Object)"else-case");
                                }
                                if (var7_20 == null && imaginaryPart) {
                                    Integer integer = vf.valueOf(sign * 1);
                                }
                                sign = 1;
                                imaginaryPart = false;
                                continue;
                            }
                            if (this.found("-", source, status)) {
                                if (!$assertionsDisabled && val != null) {
                                    throw new AssertionError((Object)"else-case");
                                }
                                if (var7_20 == null && imaginaryPart) {
                                    Integer integer = vf.valueOf(sign * 1);
                                }
                                sign = -1;
                                imaginaryPart = false;
                                continue;
                            }
                            if (status.getIndex() >= source.length()) continue;
                            break;
                        }
                        if (var7_20 == null && imaginaryPart) {
                            if (!$assertionsDisabled && val != null) {
                                throw new AssertionError((Object)"");
                            }
                            Integer integer = vf.valueOf(sign * 1);
                        }
                        if (var7_25 == null) {
                            throw new NumberFormatException("real value does not need to be parsed as a complex");
                        }
                        if (re != null) return vf.complex(re, (Real)var7_25);
                        return vf.complex(Values.ZERO, (Real)var7_25);
                    }
                    catch (NumberFormatException trial) {
                        status.setIndex(fallbackIndex);
                    }
                }
                if (source.indexOf(this.rationalSeparator, status.getIndex()) >= 0) {
                    int fallbackIndex = status.getIndex();
                    try {
                        NumberFormat f = (NumberFormat)this.numberFormat.clone();
                        f.setParseIntegerOnly(true);
                        Integer integer = (Integer)vf.valueOf(f.parse(source, status));
                        if (integer == null) {
                            throw new NumberFormatException("numerator expected");
                        }
                        if (!this.found(this.rationalSeparator, source, status)) {
                            throw new NumberFormatException("'" + this.rationalSeparator + "' expected");
                        }
                        Integer denominator = (Integer)vf.valueOf(f.parse(source, status));
                        if (denominator != null) return vf.rational(integer, denominator);
                        throw new NumberFormatException("denominator expected");
                    }
                    catch (NumberFormatException trial) {
                        status.setIndex(fallbackIndex);
                    }
                }
                if ((n = this.numberFormat.parse(source, status)) != null) {
                    return vf.narrow(vf.valueOf(n));
                }
                if (!Character.isWhitespace(source.charAt(status.getIndex()))) return null;
                status.setIndex(status.getIndex() + 1);
            }
        }
        catch (ExpectationHurtParseException invalid) {
            status.setIndex(initialIndex);
            return null;
        }
    }

    public Object parseObject(String source, ParsePosition status) {
        return this.parse(source, status);
    }

    public Arithmetic parse(String source) throws ParseException {
        ParsePosition status = new ParsePosition(0);
        Arithmetic result = this.parse(source, status);
        if (status.getIndex() == 0) {
            throw new ParseException("ArithmeticFormat.parse(String) failed at " + status + " '" + source.charAt(status.getErrorIndex()) + "'", status.getErrorIndex());
        }
        return result;
    }

    private final void consume(String expectedValue, String source, ParsePosition status) throws ExpectationHurtParseException {
        if (!this.found(expectedValue, source, status)) {
            status.setErrorIndex(status.getIndex());
            throw new ExpectationHurtParseException("'" + expectedValue + "' expected", status.getErrorIndex());
        }
    }

    private final boolean found(String value, String source, ParsePosition status) {
        if (source.startsWith(value, status.getIndex())) {
            status.setIndex(status.getIndex() + value.length());
            return true;
        }
        return false;
    }

    private final boolean found(String[] values, String source, ParsePosition status) {
        for (int i = 0; i < values.length; ++i) {
            if (!this.found(values[i], source, status)) continue;
            return true;
        }
        return false;
    }

    private static final Real realValueOf(Number number) {
        return number == null ? null : Values.getDefaultInstance().valueOf(number.doubleValue());
    }

    static {
        $assertionsDisabled = !ArithmeticFormat.class.desiredAssertionStatus();
        logger = Logger.getLogger(ArithmeticFormat.class.getPackage().getName());
        defaultFormat = ArithmeticFormat.getInstance(Locale.ENGLISH);
    }
}

