/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.functor;

import orbital.logic.functor.BinaryPredicate;
import orbital.logic.functor.VoidPredicate;
import orbital.logic.sign.concrete.Notation;
import orbital.util.Utility;

public final class Predicates {
    public static final Predicates predicates = new Predicates();
    public static final VoidPredicate TRUE = new ConstantPredicate(true);
    public static final VoidPredicate FALSE = new ConstantPredicate(false);
    public static final BinaryPredicate equal = new BinaryPredicate(){

        public boolean apply(Object a, Object b) {
            return Utility.equals(a, b);
        }

        public String toString() {
            return "=";
        }
    };
    public static final BinaryPredicate unequal = new BinaryPredicate(){

        public boolean apply(Object a, Object b) {
            return !Utility.equals(a, b);
        }

        public String toString() {
            return "!=";
        }
    };
    public static final BinaryPredicate less = new BinaryPredicate(){

        public boolean apply(Object a, Object b) {
            return ((Comparable)a).compareTo(b) < 0;
        }

        public String toString() {
            return "<";
        }
    };
    public static final BinaryPredicate greater = new BinaryPredicate(){

        public boolean apply(Object a, Object b) {
            return ((Comparable)a).compareTo(b) > 0;
        }

        public String toString() {
            return ">";
        }
    };
    public static final BinaryPredicate lessEqual = new BinaryPredicate(){

        public boolean apply(Object a, Object b) {
            return ((Comparable)a).compareTo(b) <= 0;
        }

        public String toString() {
            return "=<";
        }
    };
    public static final BinaryPredicate greaterEqual = new BinaryPredicate(){

        public boolean apply(Object a, Object b) {
            return ((Comparable)a).compareTo(b) >= 0;
        }

        public String toString() {
            return ">=";
        }
    };

    private Predicates() {
    }

    static {
        Notation.setAllNotations(new Object[][]{{equal, new Notation.NotationSpecification(700, "xfx", Notation.INFIX)}, {unequal, new Notation.NotationSpecification(700, "xfx", Notation.INFIX)}, {greater, new Notation.NotationSpecification(700, "xfx", Notation.INFIX)}, {less, new Notation.NotationSpecification(700, "xfx", Notation.INFIX)}, {greaterEqual, new Notation.NotationSpecification(700, "xfx", Notation.INFIX)}, {lessEqual, new Notation.NotationSpecification(700, "xfx", Notation.INFIX)}});
    }

    private static final class ConstantPredicate
    implements VoidPredicate {
        private boolean a;

        ConstantPredicate(boolean a) {
            this.a = a;
        }

        public boolean getConstant() {
            return this.a;
        }

        public boolean apply() {
            return this.a;
        }

        public final boolean equals(Object o) {
            return super.equals(o);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.a + "";
        }
    }
}

