/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.functor;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import orbital.logic.IterationLimitException;
import orbital.logic.functor.AbstractCompositeFunctor;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.BinaryPredicate;
import orbital.logic.functor.Compositions;
import orbital.logic.functor.Function;
import orbital.logic.functor.Functions;
import orbital.logic.functor.Functor;
import orbital.logic.functor.ParallelIterator;
import orbital.logic.functor.Predicate;
import orbital.logic.functor.VoidFunction;
import orbital.logic.functor.VoidPredicate;
import orbital.logic.sign.concrete.Notation;
import orbital.util.Pair;
import orbital.util.Setops;
import orbital.util.Utility;

public class Functionals {
    public static final Functionals functionals;
    public static final BinaryFunction compose;
    public static final BinaryFunction apply;
    static /* synthetic */ Class class$orbital$logic$functor$Function;
    static /* synthetic */ Class class$orbital$logic$functor$VoidFunction;
    static /* synthetic */ Class class$java$lang$Object;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Functionals() {
    }

    public static Function cross(final Function f, final Function g) {
        return new Function(){

            public Object apply(Object x) {
                return new Pair(f.apply(x), g.apply(x));
            }

            public String toString() {
                return "(" + f + "\u00d7" + g + ")";
            }
        };
    }

    public static Function.Composite compose(Function f, Function g) {
        return new Compositions.CompositeFunction(f, g);
    }

    public static BinaryFunction.Composite compose(BinaryFunction f, BinaryFunction g, BinaryFunction h) {
        return new Compositions.CompositeBinaryFunction(f, g, h);
    }

    public static Function.Composite compose(BinaryFunction f, Function g, Function h) {
        return new BinaryCompositeFunction(f, g, h);
    }

    public static VoidFunction.Composite compose(Function f, VoidFunction g) {
        return new Compositions.CompositeVoidFunction(f, g);
    }

    public static VoidFunction.Composite compose(BinaryFunction f, VoidFunction g, VoidFunction h) {
        return new BinaryCompositeVoidFunction(f, g, h);
    }

    public static Predicate.Composite compose(Predicate P, Function g) {
        return new Compositions.CompositePredicate(P, g);
    }

    public static BinaryPredicate.Composite compose(BinaryPredicate P, BinaryFunction g, BinaryFunction h) {
        return new Compositions.CompositeBinaryPredicate(P, g, h);
    }

    public static Predicate.Composite compose(BinaryPredicate P, Function g, Function h) {
        return new BinaryCompositePredicate(P, g, h);
    }

    public static VoidPredicate.Composite compose(Predicate P, VoidFunction g) {
        return new Compositions.CompositeVoidPredicate(P, g);
    }

    public static VoidPredicate.Composite compose(BinaryPredicate P, VoidFunction g, VoidFunction h) {
        return new BinaryCompositeVoidPredicate(P, g, h);
    }

    public static Functor.Composite genericCompose(Function f, Object g) {
        if (g instanceof Functor) {
            if (g instanceof Function) {
                return Functionals.compose(f, (Function)g);
            }
            if (g instanceof VoidFunction) {
                return Functionals.compose(f, (VoidFunction)g);
            }
        } else {
            return Functionals.compose(f, Functions.constant(g));
        }
        throw new IllegalArgumentException("illegal type to compose " + (g == null ? "null" : g.getClass() + ""));
    }

    public static Functor.Composite genericCompose(BinaryFunction f, Object g, Object h) {
        if (g instanceof Functor && h instanceof Functor) {
            if (g instanceof Function && h instanceof Function) {
                return Functionals.compose(f, (Function)g, (Function)h);
            }
            if (g instanceof BinaryFunction && h instanceof BinaryFunction) {
                return Functionals.compose(f, (BinaryFunction)g, (BinaryFunction)h);
            }
            if (g instanceof VoidFunction && h instanceof VoidFunction) {
                return Functionals.compose(f, (VoidFunction)g, (VoidFunction)h);
            }
        } else if (g instanceof Functor || h instanceof Functor) {
            if (!$assertionsDisabled && !(g instanceof Functor ^ h instanceof Functor)) {
                throw new AssertionError((Object)"!(a&b)&(a|b) -> (a^b)");
            }
            if (g instanceof Function) {
                return Functionals.compose(f, (Function)g, Functions.constant(h));
            }
            if (h instanceof Function) {
                return Functionals.compose(f, Functions.constant(g), (Function)h);
            }
            if (g instanceof BinaryFunction) {
                return Functionals.compose(f, (BinaryFunction)g, Functions.binaryConstant(h));
            }
            if (h instanceof BinaryFunction) {
                return Functionals.compose(f, Functions.binaryConstant(g), (BinaryFunction)h);
            }
        } else {
            return Functionals.compose(f, Functions.constant(g), Functions.constant(h));
        }
        throw new ClassCastException("the type of the arguments to compose do not match " + (g == null ? "null" : g.getClass() + "") + ", " + (h == null ? "null" : h.getClass() + ""));
    }

    public static Functor.Composite genericCompose(BinaryPredicate P, Object g, Object h) {
        if (g instanceof Function && h instanceof Function) {
            return Functionals.compose(P, (Function)g, (Function)h);
        }
        if (g instanceof BinaryFunction && h instanceof BinaryFunction) {
            return Functionals.compose(P, (BinaryFunction)g, (BinaryFunction)h);
        }
        if (g instanceof VoidFunction && h instanceof VoidFunction) {
            return Functionals.compose(P, (VoidFunction)g, (VoidFunction)h);
        }
        throw new ClassCastException("the type of the arguments to compose do not match " + (g == null ? "null" : g.getClass() + "") + ", " + (h == null ? "null" : h.getClass() + ""));
    }

    public static Function curry(BinaryFunction f) {
        return new CurryFunction(f);
    }

    public static BinaryFunction uncurry(Function f) {
        return f instanceof CurryFunction ? ((CurryFunction)f).f : new UnCurryFunction(f);
    }

    public static Function bindFirst(BinaryFunction f, Object x) {
        return new BindFirstFunction(f, x);
    }

    public static Predicate bindFirst(BinaryPredicate P, Object x) {
        return new BindFirstPredicate(P, x);
    }

    public static Function bindSecond(BinaryFunction f, Object y) {
        return new BindSecondFunction(f, y);
    }

    public static Predicate bindSecond(BinaryPredicate P, Object y) {
        return new BindSecondPredicate(P, y);
    }

    public static VoidFunction bind(Function f, Object a) {
        return new BindFunction(f, a);
    }

    public static VoidPredicate bind(Predicate P, Object a) {
        return new BindPredicate(P, a);
    }

    public static Function bind(BinaryFunction f) {
        return new BindTogetherFunction(f);
    }

    public static Predicate bind(BinaryPredicate P) {
        return new BindTogetherPredicate(P);
    }

    public static BinaryFunction onFirst(Function f) {
        return new BinaryFunctionOnFirst(f);
    }

    public static BinaryPredicate onFirst(Predicate p) {
        return new BinaryPredicateOnFirst(p);
    }

    public static BinaryFunction onSecond(Function f) {
        return new BinaryFunctionOnSecond(f);
    }

    public static BinaryPredicate onSecond(Predicate p) {
        return new BinaryPredicateOnSecond(p);
    }

    public static Function onVoid(VoidFunction f) {
        return new FunctionOnVoid(f);
    }

    public static Predicate onVoid(VoidPredicate p) {
        return new PredicateOnVoid(p);
    }

    public static BinaryFunction swap(BinaryFunction f) {
        return f instanceof SwapFunction ? ((SwapFunction)f).f : new SwapFunction(f);
    }

    public static BinaryPredicate swap(BinaryPredicate P) {
        return P instanceof SwapPredicate ? ((SwapPredicate)P).P : new SwapPredicate(P);
    }

    public static VoidFunction asFunction(VoidPredicate p) {
        return new VoidPredicateFunction(p);
    }

    public static Function asFunction(Predicate p) {
        return new PredicateFunction(p);
    }

    public static BinaryFunction asFunction(BinaryPredicate p) {
        return new BinaryPredicateFunction(p);
    }

    public static Function listable(Function f) {
        return f instanceof ListableFunction ? f : new ListableFunction(f);
    }

    protected static final void mapInto(Function f, Iterator a, ListIterator r) {
        while (a.hasNext()) {
            Object fa = f.apply(a.next());
            if (r.hasNext()) {
                r.next();
                r.set(fa);
                continue;
            }
            r.add(fa);
        }
    }

    private static Collection mapInto(Function f, Iterator a, Collection r) {
        while (a.hasNext()) {
            r.add(f.apply(a.next()));
        }
        return r;
    }

    public static Collection map(Function f, Collection a) {
        return Functionals.mapInto(f, a.iterator(), Setops.newCollectionLike(a));
    }

    public static List map(Function f, List a) {
        return (List)Functionals.map(f, (Collection)a);
    }

    public static Set map(Function f, Set a) {
        return (Set)Functionals.map(f, (Collection)a);
    }

    public static SortedSet map(Function f, SortedSet a) {
        return (SortedSet)Functionals.map(f, (Collection)a);
    }

    public static Iterator map(Function f, Iterator a) {
        return Functionals.mapInto(f, a, new LinkedList()).iterator();
    }

    public static ListIterator map(Function f, ListIterator a) {
        return ((List)Functionals.mapInto(f, (Iterator)a, new LinkedList())).listIterator();
    }

    public static Object[] map(Function f, Object[] a) {
        Object[] r = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length);
        for (int i = 0; i < r.length; ++i) {
            r[i] = f.apply(a[i]);
        }
        return r;
    }

    protected static final Object map(Function f, Object a) {
        Object r = Utility.newIteratableLike(a);
        Functionals.mapInto(f, Utility.asIterator(a), (ListIterator)Utility.asIterator(r));
        return r;
    }

    public static BinaryFunction listable(BinaryFunction f) {
        return f instanceof ListableBinaryFunction ? f : new ListableBinaryFunction(f);
    }

    protected static void mapInto(BinaryFunction f, Iterator x, Iterator y, ListIterator t) {
        while (x.hasNext() && y.hasNext()) {
            Object fxy = f.apply(x.next(), y.next());
            if (t.hasNext()) {
                t.next();
                t.set(fxy);
                continue;
            }
            t.add(fxy);
        }
        if (x.hasNext() || y.hasNext()) {
            throw new IndexOutOfBoundsException("argument source iterators must have same length");
        }
    }

    public static Collection map(BinaryFunction f, Collection x, Collection y) {
        if (x.size() != y.size()) {
            throw new IndexOutOfBoundsException("argument collections must have same size");
        }
        return Functionals.mapInto(f, x.iterator(), y.iterator(), Setops.newCollectionLike(x));
    }

    public static List map(BinaryFunction f, List x, List y) {
        return (List)Functionals.map(f, (Collection)x, (Collection)y);
    }

    public static Set map(BinaryFunction f, Set x, Set y) {
        return (Set)Functionals.map(f, (Collection)x, (Collection)y);
    }

    public static SortedSet map(BinaryFunction f, SortedSet x, SortedSet y) {
        Utility.pre(Utility.equals(x.comparator(), y.comparator()), "need equal comparators for choosing a comparator for the resulting " + SortedSet.class.getName());
        return (SortedSet)Functionals.map(f, (Collection)x, (Collection)y);
    }

    public static Iterator map(BinaryFunction f, Iterator x, Iterator y) {
        return Functionals.mapInto(f, x, y, new LinkedList()).iterator();
    }

    public static ListIterator map(BinaryFunction f, ListIterator x, ListIterator y) {
        return ((List)Functionals.mapInto(f, (Iterator)x, (Iterator)y, new LinkedList())).listIterator();
    }

    public static Object[] map(BinaryFunction f, Object[] x, Object[] y) {
        if (x.length != y.length) {
            throw new IndexOutOfBoundsException("argument arrays must have same length");
        }
        Object[] a = (Object[])Array.newInstance(x.getClass().getComponentType(), x.length);
        for (int i = 0; i < a.length; ++i) {
            a[i] = f.apply(x[i], y[i]);
        }
        return a;
    }

    private static Collection mapInto(BinaryFunction f, Iterator x, Iterator y, Collection r) {
        while (x.hasNext() && y.hasNext()) {
            r.add(f.apply(x.next(), y.next()));
        }
        if (x.hasNext() || y.hasNext()) {
            throw new IndexOutOfBoundsException("argument source iterators must have same length");
        }
        return r;
    }

    private static final Object map(BinaryFunction f, Object a, Object b) {
        Object r = Utility.newIteratableLike(a);
        if (!r.equals(Utility.newIteratableLike(b))) {
            throw new IndexOutOfBoundsException("arguments must have same structure");
        }
        Functionals.mapInto(f, Utility.asIterator(a), Utility.asIterator(b), (ListIterator)Utility.asIterator(r));
        return r;
    }

    public static Object foldLeft(BinaryFunction f, Object c, Object[] a) {
        Object accumulated = c;
        for (int i = 0; i < a.length; ++i) {
            accumulated = f.apply(accumulated, a[i]);
        }
        return accumulated;
    }

    public static Object foldLeft(BinaryFunction f, Object c, Iterator a) {
        Object accumulated = c;
        while (a.hasNext()) {
            accumulated = f.apply(accumulated, a.next());
        }
        return accumulated;
    }

    public static Object foldLeft(BinaryFunction f, Object c, Collection a) {
        return Functionals.foldLeft(f, c, a.iterator());
    }

    public static Object foldRight(BinaryFunction f, Object c, Object[] a) {
        Object result = c;
        for (int i = a.length - 1; i >= 0; --i) {
            result = f.apply(a[i], result);
        }
        return result;
    }

    public static Object foldRight(BinaryFunction f, Object c, List a) {
        Object result = c;
        ListIterator i = a.listIterator(a.size());
        while (i.hasPrevious()) {
            result = f.apply(i.previous(), result);
        }
        return result;
    }

    public static Object foldRight(BinaryFunction f, Object c, Collection a) {
        return Functionals.banana(c, f, a.iterator());
    }

    public static Object foldRight(BinaryFunction f, Object c, Iterator a) {
        return Functionals.banana(c, f, a);
    }

    public static Object banana(Object c, BinaryFunction f, Iterator a) {
        return new Catamorphism(c, f).apply(a);
    }

    public static List lense(Function g, Predicate p, Object b) {
        return (List)new Anamorphism(g, p).apply(b);
    }

    public static Object envelope(Object c, BinaryFunction f, Function g, Predicate p, Object a) {
        return new Hylomorphism(c, f, g, p).apply(a);
    }

    public static Object barbedwire(Object b, BinaryFunction f, Iterator a) {
        return new Paramorphism(b, f).apply(a);
    }

    protected static Function paramorphism(final int b, final BinaryFunction f) {
        return new Function(){

            public Object apply(Object ao) {
                int a = (Integer)ao;
                if (a == 0) {
                    return new Integer(b);
                }
                return f.apply(new Integer(a - 1), this.apply(new Integer(a - 1)));
            }

            public String toString() {
                return "{|" + b + "," + f + "|}";
            }
        };
    }

    public static int barbedwire(int b, BinaryFunction f, int a) {
        return ((Number)Functionals.paramorphism(b, f).apply(new Integer(a))).intValue();
    }

    public static Function nest(Function f, int n) {
        Utility.pre(n >= 0, "non negative nesting expected");
        if (n == 0) {
            throw new UnsupportedOperationException("0 nesting not implemented. would be orbital.math.functional.Functions.id");
        }
        Function r = f;
        for (int i = 1; i < n; ++i) {
            r = Functionals.compose(f, r);
        }
        return r;
    }

    public static Object fixedPoint(Function f, Object x, int maxIteration) throws IterationLimitException {
        Object o_x = x;
        for (int i = 0; i < maxIteration; ++i) {
            o_x = x;
            if (!(x = f.apply(o_x)).equals(o_x)) continue;
            return x;
        }
        throw new IterationLimitException("limit of fixed point iterations (" + maxIteration + ") reached");
    }

    public static Object fixedPoint(Function f, Object x) throws IterationLimitException {
        try {
            return Functionals.fixedPoint(f, x, IterationLimitException.MaxIterations);
        }
        catch (IterationLimitException ex) {
            throw new IterationLimitException(ex.getMessage() + " with IterationLimitException.MaxIterations=" + IterationLimitException.MaxIterations);
        }
    }

    static {
        $assertionsDisabled = !Functionals.class.desiredAssertionStatus();
        functionals = new Functionals();
        compose = new BinaryFunction(){

            public Object apply(Object f, Object g) {
                return Functionals.genericCompose((Function)f, g);
            }
        };
        apply = new BinaryFunction(){
            private final Functor.Specification callTypeDeclaration = new Functor.Specification(new Class[]{class$orbital$logic$functor$Function == null ? (class$orbital$logic$functor$Function = Functionals.class$("orbital.logic.functor.Function")) : class$orbital$logic$functor$Function, class$java$lang$Object == null ? (class$java$lang$Object = Functionals.class$("java.lang.Object")) : class$java$lang$Object}, class$java$lang$Object == null ? (class$java$lang$Object = Functionals.class$("java.lang.Object")) : class$java$lang$Object);

            public Object apply(Object f, Object x) {
                return ((Function)f).apply(x);
            }

            public String toString() {
                return "@";
            }
        };
    }

    public static class Paramorphism
    implements Function,
    Serializable {
        private static final long serialVersionUID = 6420642534953643932L;
        private final Object b;
        private final BinaryFunction f;

        public Paramorphism(Object b, BinaryFunction f) {
            this.b = b;
            this.f = f;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Paramorphism)) {
                return false;
            }
            Paramorphism b = (Paramorphism)o;
            return (b == null ? b.b == null : b.equals(b.b)) && (this.f == null ? b.f == null : this.f.equals(b.f));
        }

        public int hashCode() {
            return this.b.hashCode() ^ this.f.hashCode();
        }

        public final Object apply(Object a) {
            return this.apply(Utility.asIterator(a));
        }

        private final Object apply(Iterator ai) {
            if (!ai.hasNext()) {
                return this.b;
            }
            Object x = ai.next();
            ParallelIterator clone = new ParallelIterator(ai);
            ai = clone.getParallel();
            return this.f.apply(x, new Pair(clone, this.apply(ai)));
        }

        public String toString() {
            return "{|" + this.b + ',' + this.f + "|}";
        }
    }

    public static class Hylomorphism
    implements Function,
    Serializable {
        private static final long serialVersionUID = 8982420605715979366L;
        private final Object c;
        private final BinaryFunction f;
        private final Function g;
        private final Predicate p;

        public Hylomorphism(Object c, BinaryFunction f, Function g, Predicate p) {
            this.c = c;
            this.f = f;
            this.g = g;
            this.p = p;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Hylomorphism)) {
                return false;
            }
            Hylomorphism b = (Hylomorphism)o;
            return (this.c == null ? b.c == null : this.c.equals(b.c)) && (this.f == null ? b.f == null : this.f.equals(b.f)) && (this.g == null ? b.g == null : this.g.equals(b.g)) && (this.p == null ? b.p == null : this.p.equals(b.p));
        }

        public int hashCode() {
            return this.c.hashCode() ^ this.f.hashCode() ^ this.g.hashCode() ^ this.p.hashCode();
        }

        public final Object apply(Object a) {
            if (this.p.apply(a)) {
                return this.c;
            }
            Pair pair = (Pair)this.g.apply(a);
            return this.f.apply(pair.A, this.apply(pair.B));
        }

        public String toString() {
            return "|[(" + this.c + ',' + this.f + "),(" + this.g + ',' + this.p + ')' + "]|";
        }
    }

    public static class Anamorphism
    implements Function,
    Serializable {
        private static final long serialVersionUID = -1984167910200783901L;
        private final Function g;
        private final Predicate p;

        public Anamorphism(Function g, Predicate p) {
            this.g = g;
            this.p = p;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Anamorphism)) {
                return false;
            }
            Anamorphism b = (Anamorphism)o;
            return (this.g == null ? b.g == null : this.g.equals(b.g)) && (this.p == null ? b.p == null : this.p.equals(b.p));
        }

        public int hashCode() {
            return this.g.hashCode() ^ this.p.hashCode();
        }

        public final Object apply(Object b) {
            if (this.p.apply(b)) {
                return new LinkedList();
            }
            Pair pair = (Pair)this.g.apply(b);
            List r = (List)this.apply(pair.B);
            r.add(0, pair.A);
            return r;
        }

        public String toString() {
            return "[(" + this.g + ',' + this.p + ")]";
        }
    }

    public static class Catamorphism
    implements Function,
    Serializable {
        private static final long serialVersionUID = -6922299620063576629L;
        protected final Object c;
        protected final BinaryFunction f;

        public Catamorphism(Object c, BinaryFunction f) {
            this.c = c;
            this.f = f;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Catamorphism)) {
                return false;
            }
            Catamorphism b = (Catamorphism)o;
            return (this.c == null ? b.c == null : this.c.equals(b.c)) && (this.f == null ? b.f == null : this.f.equals(b.f));
        }

        public int hashCode() {
            return this.c.hashCode() ^ this.f.hashCode();
        }

        public final Object apply(Object a) {
            return this.apply(Utility.asIterator(a));
        }

        private final Object apply(Iterator it) {
            if (!it.hasNext()) {
                return this.c;
            }
            return this.f.apply(it.next(), this.apply(it));
        }

        public String toString() {
            return "(|" + this.c + ',' + this.f + "|)";
        }
    }

    private static class ListableBinaryFunction
    implements BinaryFunction,
    Serializable {
        private static final long serialVersionUID = -597652995077337878L;
        protected final BinaryFunction function;

        public ListableBinaryFunction(BinaryFunction function) {
            this.function = function;
        }

        public Object getCompositor() {
            return this.function;
        }

        public Object apply(Object x, Object y) {
            if (x instanceof Collection && y instanceof Collection) {
                if (x instanceof List && y instanceof List) {
                    return Functionals.map((BinaryFunction)this, (List)x, (List)y);
                }
                if (x instanceof SortedSet && y instanceof SortedSet) {
                    return Functionals.map((BinaryFunction)this, (SortedSet)x, (SortedSet)y);
                }
                if (x instanceof Set && y instanceof Set) {
                    return Functionals.map((BinaryFunction)this, (Set)x, (Set)y);
                }
                return Functionals.map((BinaryFunction)this, (Collection)x, (Collection)y);
            }
            if (x instanceof Iterator && y instanceof Iterator) {
                if (x instanceof ListIterator && y instanceof ListIterator) {
                    return Functionals.map((BinaryFunction)this, (ListIterator)x, (ListIterator)y);
                }
                return Functionals.map((BinaryFunction)this, (Iterator)x, (Iterator)y);
            }
            if (Utility.isIteratable(x) && Utility.isIteratable(y)) {
                return Functionals.map(this, x, y);
            }
            return this.function.apply(x, y);
        }

        public boolean equals(Object o) {
            if (o instanceof ListableBinaryFunction) {
                return this.getCompositor().equals(((ListableFunction)o).getCompositor());
            }
            return false;
        }

        public int hashCode() {
            return Utility.hashCode(this.function);
        }

        public String toString() {
            return this.function + "";
        }
    }

    private static class ListableFunction
    implements Function,
    Serializable {
        private static final long serialVersionUID = 5667915275261829138L;
        protected final Function function;

        public ListableFunction(Function function) {
            this.function = function;
        }

        public Object getCompositor() {
            return this.function;
        }

        public Object apply(Object x) {
            if (x instanceof Collection) {
                if (x instanceof List) {
                    return Functionals.map((Function)this, (List)x);
                }
                if (x instanceof SortedSet) {
                    return Functionals.map((Function)this, (SortedSet)x);
                }
                if (x instanceof Set) {
                    return Functionals.map((Function)this, (Set)x);
                }
                return Functionals.map((Function)this, (Collection)x);
            }
            if (x instanceof Iterator) {
                if (x instanceof ListIterator) {
                    return Functionals.map((Function)this, (ListIterator)x);
                }
                return Functionals.map((Function)this, (Iterator)x);
            }
            if (Utility.isIteratable(x)) {
                return Functionals.map((Function)this, x);
            }
            return this.function.apply(x);
        }

        public boolean equals(Object o) {
            if (o instanceof ListableFunction) {
                return this.getCompositor().equals(((ListableFunction)o).getCompositor());
            }
            return false;
        }

        public int hashCode() {
            return Utility.hashCode(this.function);
        }

        public String toString() {
            return this.function + "";
        }
    }

    private static class BinaryPredicateFunction
    implements BinaryFunction {
        private static final long serialVersionUID = -6039054390567866829L;
        protected BinaryPredicate p;

        public BinaryPredicateFunction(BinaryPredicate p) {
            this.p = p;
        }

        private BinaryPredicateFunction() {
        }

        public boolean equals(Object o) {
            return o instanceof BinaryPredicateFunction && Utility.equals(this.p, ((BinaryPredicateFunction)o).p);
        }

        public int hashCode() {
            return Utility.hashCode(this.p);
        }

        public String toString() {
            return this.p.toString();
        }

        public Object apply(Object x, Object y) {
            return new Boolean(this.p.apply(x, y));
        }

        public Object getCompositor() {
            return this.p;
        }

        public Object getComponent() {
            return new String[0];
        }

        public void setCompositor(Object f) throws ClassCastException {
            this.p = (BinaryPredicate)f;
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            Object[] a = (Object[])g;
            if (a.length != 0) {
                throw new IllegalArgumentException("zero components expected");
            }
        }
    }

    private static class PredicateFunction
    implements Function {
        private static final long serialVersionUID = 5923239404848442075L;
        protected Predicate p;

        public PredicateFunction(Predicate p) {
            this.p = p;
        }

        private PredicateFunction() {
        }

        public boolean equals(Object o) {
            return o instanceof PredicateFunction && Utility.equals(this.p, ((PredicateFunction)o).p);
        }

        public int hashCode() {
            return Utility.hashCode(this.p);
        }

        public String toString() {
            return this.p.toString();
        }

        public Object apply(Object x) {
            return new Boolean(this.p.apply(x));
        }

        public Object getCompositor() {
            return this.p;
        }

        public Object getComponent() {
            return new String[0];
        }

        public void setCompositor(Object f) throws ClassCastException {
            this.p = (Predicate)f;
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            Object[] a = (Object[])g;
            if (a.length != 0) {
                throw new IllegalArgumentException("zero components expected");
            }
        }
    }

    private static class VoidPredicateFunction
    implements VoidFunction {
        private static final long serialVersionUID = -578056603334602720L;
        protected VoidPredicate p;

        public VoidPredicateFunction(VoidPredicate p) {
            this.p = p;
        }

        private VoidPredicateFunction() {
        }

        public boolean equals(Object o) {
            return o instanceof VoidPredicateFunction && Utility.equals(this.p, ((VoidPredicateFunction)o).p);
        }

        public int hashCode() {
            return Utility.hashCode(this.p);
        }

        public String toString() {
            return this.p.toString();
        }

        public Object apply() {
            return new Boolean(this.p.apply());
        }

        public Object getCompositor() {
            return this.p;
        }

        public Object getComponent() {
            return new Object[0];
        }

        public void setCompositor(Object f) throws ClassCastException {
            this.p = (VoidPredicate)f;
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            Object[] a = (Object[])g;
            if (a.length != 0) {
                throw new IllegalArgumentException("zero components expected");
            }
        }
    }

    private static class SwapPredicate
    extends AbstractCompositeFunctor
    implements BinaryPredicate {
        private static final long serialVersionUID = -6620068267897084655L;
        protected final BinaryPredicate P;

        public SwapPredicate(BinaryPredicate P, Notation notation) {
            super(notation);
            this.P = P;
        }

        public SwapPredicate(BinaryPredicate P) {
            this(P, null);
        }

        public boolean apply(Object x, Object y) {
            return this.P.apply(y, x);
        }

        public Object getCompositor() {
            return this.P;
        }

        public Object getComponent() {
            return new String[]{"#1", "#0"};
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class SwapFunction
    extends AbstractCompositeFunctor
    implements BinaryFunction {
        private static final long serialVersionUID = -4517373861424750032L;
        protected final BinaryFunction f;

        public SwapFunction(BinaryFunction f, Notation notation) {
            super(notation);
            this.f = f;
        }

        public SwapFunction(BinaryFunction f) {
            this(f, null);
        }

        public Object apply(Object x, Object y) {
            return this.f.apply(y, x);
        }

        public Object getCompositor() {
            return this.f;
        }

        public Object getComponent() {
            return new String[]{"#1", "#0"};
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class PredicateOnVoid
    implements Predicate {
        private final VoidPredicate p;

        public PredicateOnVoid(VoidPredicate p) {
            this.p = p;
        }

        public boolean equals(Object o) {
            return o instanceof PredicateOnVoid && this.p.equals(((PredicateOnVoid)o).p);
        }

        public int hashCode() {
            return this.p.hashCode();
        }

        public boolean apply(Object arg) {
            return this.p.apply();
        }

        public String toString() {
            return Notation.DEFAULT.format(this.p, new String[0]);
        }
    }

    private static class FunctionOnVoid
    implements Function {
        private final VoidFunction f;

        public FunctionOnVoid(VoidFunction f) {
            this.f = f;
        }

        public boolean equals(Object o) {
            return o instanceof FunctionOnVoid && this.f.equals(((FunctionOnVoid)o).f);
        }

        public int hashCode() {
            return this.f.hashCode();
        }

        public Object apply(Object arg) {
            return this.f.apply();
        }

        public String toString() {
            return Notation.DEFAULT.format(this.f, new String[0]);
        }
    }

    private static class BinaryPredicateOnSecond
    implements BinaryPredicate {
        private final Predicate f;

        public BinaryPredicateOnSecond(Predicate f) {
            this.f = f;
        }

        public boolean equals(Object o) {
            return o instanceof BinaryPredicateOnSecond && this.f.equals(((BinaryPredicateOnSecond)o).f);
        }

        public int hashCode() {
            return this.f.hashCode();
        }

        public boolean apply(Object first, Object second) {
            return this.f.apply(second);
        }

        public String toString() {
            return Notation.DEFAULT.format(this.f, new String[]{"#1"});
        }
    }

    private static class BinaryFunctionOnSecond
    implements BinaryFunction {
        private final Function f;

        public BinaryFunctionOnSecond(Function f) {
            this.f = f;
        }

        public boolean equals(Object o) {
            return o instanceof BinaryFunctionOnSecond && this.f.equals(((BinaryFunctionOnSecond)o).f);
        }

        public int hashCode() {
            return this.f.hashCode();
        }

        public Object apply(Object first, Object second) {
            return this.f.apply(second);
        }

        public String toString() {
            return Notation.DEFAULT.format(this.f, new String[]{"#1"});
        }
    }

    private static class BinaryPredicateOnFirst
    implements BinaryPredicate {
        private final Predicate f;

        public BinaryPredicateOnFirst(Predicate f) {
            this.f = f;
        }

        public boolean equals(Object o) {
            return o instanceof BinaryPredicateOnFirst && this.f.equals(((BinaryPredicateOnFirst)o).f);
        }

        public int hashCode() {
            return this.f.hashCode();
        }

        public boolean apply(Object first, Object second) {
            return this.f.apply(first);
        }

        public String toString() {
            return Notation.DEFAULT.format(this.f, new String[]{"#0"});
        }
    }

    private static class BinaryFunctionOnFirst
    implements BinaryFunction {
        private final Function f;

        public BinaryFunctionOnFirst(Function f) {
            this.f = f;
        }

        public boolean equals(Object o) {
            return o instanceof BinaryFunctionOnFirst && this.f.equals(((BinaryFunctionOnFirst)o).f);
        }

        public int hashCode() {
            return this.f.hashCode();
        }

        public Object apply(Object first, Object second) {
            return this.f.apply(first);
        }

        public String toString() {
            return Notation.DEFAULT.format(this.f, new String[]{"#0"});
        }
    }

    private static class BindTogetherPredicate
    extends AbstractCompositeFunctor
    implements Predicate {
        private static final long serialVersionUID = 1637786124930484045L;
        protected final BinaryPredicate P;

        public BindTogetherPredicate(BinaryPredicate P, Notation notation) {
            super(notation);
            this.P = P;
        }

        public BindTogetherPredicate(BinaryPredicate P) {
            this(P, null);
        }

        public boolean apply(Object x) {
            return this.P.apply(x, x);
        }

        public Object getCompositor() {
            return this.P;
        }

        public Object getComponent() {
            return new String[]{"#0", "#0"};
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class BindTogetherFunction
    extends AbstractCompositeFunctor
    implements Function {
        private static final long serialVersionUID = -600090844190215573L;
        protected final BinaryFunction f;

        public BindTogetherFunction(BinaryFunction f, Notation notation) {
            super(notation);
            this.f = f;
        }

        public BindTogetherFunction(BinaryFunction f) {
            this(f, null);
        }

        public Object apply(Object x) {
            return this.f.apply(x, x);
        }

        public Object getCompositor() {
            return this.f;
        }

        public Object getComponent() {
            return new String[]{"#0", "#0"};
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class BindPredicate
    extends AbstractCompositeFunctor
    implements VoidPredicate {
        private static final long serialVersionUID = -2451413984225638156L;
        protected final Predicate P;
        protected final Object a;

        public BindPredicate(Predicate P, Object a, Notation notation) {
            super(notation);
            this.P = P;
            this.a = a;
        }

        public BindPredicate(Predicate P, Object a) {
            this(P, a, null);
        }

        public boolean apply() {
            return this.P.apply(this.a);
        }

        public Object getCompositor() {
            return this.P;
        }

        public Object getComponent() {
            return null;
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class BindFunction
    extends AbstractCompositeFunctor
    implements VoidFunction {
        private static final long serialVersionUID = 5132012636675575358L;
        protected final Function f;
        protected final Object a;

        public BindFunction(Function f, Object a, Notation notation) {
            super(notation);
            this.f = f;
            this.a = a;
        }

        public BindFunction(Function f, Object a) {
            this(f, a, null);
        }

        public Object apply() {
            return this.f.apply(this.a);
        }

        public Object getCompositor() {
            return this.f;
        }

        public Object getComponent() {
            return null;
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class BindSecondPredicate
    extends AbstractCompositeFunctor
    implements Predicate {
        private static final long serialVersionUID = 3937101303664977689L;
        protected final BinaryPredicate P;
        protected final Object y;

        public BindSecondPredicate(BinaryPredicate P, Object y, Notation notation) {
            super(notation);
            this.P = P;
            this.y = y;
        }

        public BindSecondPredicate(BinaryPredicate P, Object y) {
            this(P, y, null);
        }

        public boolean apply(Object x) {
            return this.P.apply(x, this.y);
        }

        public Object getCompositor() {
            return this.P;
        }

        public Object getComponent() {
            return new Object[]{"#0", this.y};
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class BindSecondFunction
    extends AbstractCompositeFunctor
    implements Function {
        private static final long serialVersionUID = 3835427826292036797L;
        protected final BinaryFunction f;
        protected final Object y;

        public BindSecondFunction(BinaryFunction f, Object y, Notation notation) {
            super(notation);
            this.f = f;
            this.y = y;
        }

        public BindSecondFunction(BinaryFunction f, Object y) {
            this(f, y, null);
        }

        public Object apply(Object x) {
            return this.f.apply(x, this.y);
        }

        public Object getCompositor() {
            return this.f;
        }

        public Object getComponent() {
            return new Object[]{"#0", this.y};
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class BindFirstPredicate
    extends AbstractCompositeFunctor
    implements Predicate {
        private static final long serialVersionUID = -2171853542298153121L;
        protected final BinaryPredicate P;
        protected final Object x;

        public BindFirstPredicate(BinaryPredicate P, Object x, Notation notation) {
            super(notation);
            this.P = P;
            this.x = x;
        }

        public BindFirstPredicate(BinaryPredicate P, Object x) {
            this(P, x, null);
        }

        public boolean apply(Object y) {
            return this.P.apply(this.x, y);
        }

        public Object getCompositor() {
            return this.P;
        }

        public Object getComponent() {
            return new Object[]{this.x, "#0"};
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class BindFirstFunction
    extends AbstractCompositeFunctor
    implements Function {
        private static final long serialVersionUID = -5691828471790998657L;
        protected final BinaryFunction f;
        protected final Object x;

        public BindFirstFunction(BinaryFunction f, Object x, Notation notation) {
            super(notation);
            this.f = f;
            this.x = x;
        }

        public BindFirstFunction(BinaryFunction f, Object x) {
            this(f, x, null);
        }

        public Object apply(Object y) {
            return this.f.apply(this.x, y);
        }

        public Object getCompositor() {
            return this.f;
        }

        public Object getComponent() {
            return new Object[]{this.x, "#0"};
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class UnCurryFunction
    extends AbstractCompositeFunctor
    implements BinaryFunction {
        private static final long serialVersionUID = -5388743542535388907L;
        protected final Function f;

        public UnCurryFunction(Function f, Notation notation) {
            super(notation);
            this.f = f;
        }

        public UnCurryFunction(Function f) {
            this(f, null);
        }

        public Object apply(Object x, Object y) {
            return ((Function)this.f.apply(x)).apply(y);
        }

        public Object getCompositor() {
            return null;
        }

        public Object getComponent() {
            return new Function[]{this.f};
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class CurryFunction
    extends AbstractCompositeFunctor
    implements Function {
        private static final long serialVersionUID = 2879348438992826191L;
        protected final BinaryFunction f;

        public CurryFunction(BinaryFunction f, Notation notation) {
            super(notation);
            this.f = f;
        }

        public CurryFunction(BinaryFunction f) {
            this(f, null);
        }

        public Object apply(Object x) {
            return Functionals.bindFirst(this.f, x);
        }

        public Object getCompositor() {
            return null;
        }

        public Object getComponent() {
            return new BinaryFunction[]{this.f};
        }

        public void setCompositor(Object f) throws ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            throw new UnsupportedOperationException("how to do");
        }
    }

    private static class BinaryCompositeVoidPredicate
    extends AbstractCompositeFunctor
    implements VoidPredicate.Composite {
        private static final long serialVersionUID = -7825258835394371722L;
        protected BinaryPredicate outer;
        protected VoidFunction left;
        protected VoidFunction right;

        public BinaryCompositeVoidPredicate(BinaryPredicate f, VoidFunction g, VoidFunction h) {
            this(f, g, h, null);
        }

        public BinaryCompositeVoidPredicate(BinaryPredicate f, VoidFunction g, VoidFunction h, Notation notation) {
            super(notation);
            this.outer = f;
            this.left = g;
            this.right = h;
        }

        protected BinaryCompositeVoidPredicate() {
        }

        public Object getCompositor() {
            return this.outer;
        }

        public Object getComponent() {
            return new VoidFunction[]{this.left, this.right};
        }

        public void setCompositor(Object f) throws ClassCastException {
            this.outer = (BinaryPredicate)f;
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            VoidFunction[] a = (VoidFunction[])g;
            if (a.length != 2) {
                throw new IllegalArgumentException((class$orbital$logic$functor$VoidFunction == null ? (class$orbital$logic$functor$VoidFunction = Functionals.class$("orbital.logic.functor.VoidFunction")) : class$orbital$logic$functor$VoidFunction) + "[2] expected");
            }
            this.left = a[0];
            this.right = a[1];
        }

        public boolean apply() {
            return this.outer.apply(this.left.apply(), this.right.apply());
        }
    }

    private static class BinaryCompositePredicate
    extends AbstractCompositeFunctor
    implements Predicate.Composite {
        private static final long serialVersionUID = 1889190809841496092L;
        protected BinaryPredicate outer;
        protected Function left;
        protected Function right;

        public BinaryCompositePredicate(BinaryPredicate f, Function g, Function h) {
            this(f, g, h, null);
        }

        public BinaryCompositePredicate(BinaryPredicate f, Function g, Function h, Notation notation) {
            super(notation);
            this.outer = f;
            this.left = g;
            this.right = h;
        }

        protected BinaryCompositePredicate() {
        }

        public Object getCompositor() {
            return this.outer;
        }

        public Object getComponent() {
            return new Function[]{this.left, this.right};
        }

        public void setCompositor(Object f) throws ClassCastException {
            this.outer = (BinaryPredicate)f;
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            Function[] a = (Function[])g;
            if (a.length != 2) {
                throw new IllegalArgumentException((class$orbital$logic$functor$Function == null ? (class$orbital$logic$functor$Function = Functionals.class$("orbital.logic.functor.Function")) : class$orbital$logic$functor$Function) + "[2] expected");
            }
            this.left = a[0];
            this.right = a[1];
        }

        public boolean apply(Object arg) {
            return this.outer.apply(this.left.apply(arg), this.right.apply(arg));
        }
    }

    private static class BinaryCompositeVoidFunction
    extends AbstractCompositeFunctor
    implements VoidFunction.Composite {
        private static final long serialVersionUID = -6605821186125989437L;
        protected BinaryFunction outer;
        protected VoidFunction left;
        protected VoidFunction right;

        public BinaryCompositeVoidFunction(BinaryFunction f, VoidFunction g, VoidFunction h) {
            this(f, g, h, null);
        }

        public BinaryCompositeVoidFunction(BinaryFunction f, VoidFunction g, VoidFunction h, Notation notation) {
            super(notation);
            this.outer = f;
            this.left = g;
            this.right = h;
        }

        protected BinaryCompositeVoidFunction() {
        }

        public Object getCompositor() {
            return this.outer;
        }

        public Object getComponent() {
            return new VoidFunction[]{this.left, this.right};
        }

        public void setCompositor(Object f) throws ClassCastException {
            this.outer = (BinaryFunction)f;
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            VoidFunction[] a = (VoidFunction[])g;
            if (a.length != 2) {
                throw new IllegalArgumentException((class$orbital$logic$functor$VoidFunction == null ? (class$orbital$logic$functor$VoidFunction = Functionals.class$("orbital.logic.functor.VoidFunction")) : class$orbital$logic$functor$VoidFunction) + "[2] expected");
            }
            this.left = a[0];
            this.right = a[1];
        }

        public Object apply() {
            return this.outer.apply(this.left.apply(), this.right.apply());
        }
    }

    private static class BinaryCompositeFunction
    extends AbstractCompositeFunctor
    implements Function.Composite {
        private static final long serialVersionUID = -8125852955148387314L;
        protected BinaryFunction outer;
        protected Function left;
        protected Function right;

        public BinaryCompositeFunction(BinaryFunction f, Function g, Function h) {
            this(f, g, h, null);
        }

        public BinaryCompositeFunction(BinaryFunction f, Function g, Function h, Notation notation) {
            super(notation);
            this.outer = f;
            this.left = g;
            this.right = h;
        }

        protected BinaryCompositeFunction() {
        }

        public Object getCompositor() {
            return this.outer;
        }

        public Object getComponent() {
            return new Function[]{this.left, this.right};
        }

        public void setCompositor(Object f) throws ClassCastException {
            this.outer = (BinaryFunction)f;
        }

        public void setComponent(Object g) throws IllegalArgumentException, ClassCastException {
            Function[] a = (Function[])g;
            if (a.length != 2) {
                throw new IllegalArgumentException((class$orbital$logic$functor$Function == null ? (class$orbital$logic$functor$Function = Functionals.class$("orbital.logic.functor.Function")) : class$orbital$logic$functor$Function) + "[2] expected");
            }
            this.left = a[0];
            this.right = a[1];
        }

        public Object apply(Object arg) {
            return this.outer.apply(this.left.apply(arg), this.right.apply(arg));
        }
    }
}

