/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.functor;

import java.io.Serializable;
import orbital.logic.Composite;
import orbital.logic.functor.Functor;
import orbital.logic.sign.concrete.Notation;
import orbital.util.Utility;

abstract class AbstractCompositeFunctor
implements Functor.Composite,
Serializable {
    private static final long serialVersionUID = 4993561537088832042L;
    private Notation notation;

    protected AbstractCompositeFunctor(Notation notation) {
        this.setNotation(notation);
    }

    protected AbstractCompositeFunctor() {
        this(null);
    }

    public Composite construct(Object f, Object g) {
        try {
            Composite c = (Composite)this.getClass().newInstance();
            c.setCompositor(f);
            c.setComponent(g);
            return c;
        }
        catch (InstantiationException ass) {
            throw (UnsupportedOperationException)new UnsupportedOperationException("invariant: sub classes of " + Functor.Composite.class + " must either support nullary constructor for modification cloning or overwrite construct(Object,Object)").initCause(ass);
        }
        catch (IllegalAccessException ass) {
            throw (UnsupportedOperationException)new UnsupportedOperationException("invariant: sub classes of " + Functor.Composite.class + " must either support nullary constructor for modification cloning or overwrite construct(Object,Object)").initCause(ass);
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Functor.Composite b = (Functor.Composite)o;
        return Utility.equals(this.getCompositor(), b.getCompositor()) && Utility.equalsAll(this.getComponent(), b.getComponent());
    }

    public int hashCode() {
        return Utility.hashCode(this.getCompositor()) ^ Utility.hashCodeAll(this.getComponent());
    }

    public String toString() {
        return this.getNotation().format(this.getCompositor(), this.getComponent());
    }

    public Notation getNotation() {
        return this.notation;
    }

    public void setNotation(Notation notation) {
        this.notation = notation == null ? Notation.DEFAULT : notation;
    }
}

