/*
 * Decompiled with CFR 0.152.
 */
package orbital.game;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import orbital.game.AdversarySearch;
import orbital.game.Field;
import orbital.game.FieldChangeAdapter;
import orbital.game.FieldChangeEvent;
import orbital.game.Figure;
import orbital.game.Gameboard;
import orbital.robotic.Move;
import orbital.robotic.Position;

public class Gameboard2
extends JPanel
implements ImageObserver,
Serializable {
    private static final long serialVersionUID = 6205399044524716717L;
    private static final Logger logger;
    private Field field = null;
    private volatile transient Position dragging = null;
    private transient boolean layouting = false;
    private final PropertyChangeSupport propertyChangeListeners = new PropertyChangeSupport(this);
    static final /* synthetic */ boolean $assertionsDisabled;

    public Gameboard2() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Gameboard2.this.dragging = Gameboard2.this.figureOn(evt.getX(), evt.getY());
            }

            public void mouseReleased(MouseEvent evt) {
                Position src = Gameboard2.this.dragging;
                Gameboard2.this.dragging = null;
                if (src == null || Gameboard2.this.field.getFigure(src) == null) {
                    return;
                }
                Position dst = Gameboard2.this.figureOn(evt.getX(), evt.getY());
                if (dst == null) {
                    return;
                }
                Move moveToDst = Gameboard2.this.findValidPath(Gameboard2.this.field.getFigure(src), dst);
                boolean validOperation = moveToDst != null;
                Field nextField = null;
                try {
                    if (moveToDst != null) {
                        nextField = (Field)Gameboard2.this.field.clone();
                        validOperation &= nextField.move(src, moveToDst);
                    }
                }
                catch (CloneNotSupportedException cannotMoveHypothetically) {
                    logger.log(Level.FINE, "cannot precheck user move {0}-->{1} because of {2}", new Object[]{src, dst, cannotMoveHypothetically});
                }
                if (validOperation) {
                    Gameboard2.this.field.getFieldChangeMulticaster().movePerformed(new FieldChangeEvent(Gameboard2.this.field, 4098, new AdversarySearch.Option(nextField, dst, Gameboard2.this.field.getFigure(src), moveToDst)));
                } else {
                    logger.log(Level.WARNING, "Wrong move {0}-->{1}", new Object[]{src, dst});
                }
            }
        });
    }

    public Gameboard2(Field f) {
        this();
        this.setField(f);
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field f) {
        Field old = this.field;
        this.field = f;
        this.propertyChangeListeners.firePropertyChange("field", old, this.field);
        this.invalidate();
        this.repaint();
        this.field.addFieldChangeListener(new FieldChangeAdapter(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void componentChanged(FieldChangeEvent e) {
                if (!$assertionsDisabled && e.getField() != Gameboard2.this.getField()) {
                    throw new AssertionError((Object)("we have only registered ourselves to our field " + Gameboard2.this.getField() + " source=" + e.getField()));
                }
                if (!$assertionsDisabled && e.getType() != 1) {
                    throw new AssertionError((Object)"SET_FIGURE assumed");
                }
                if (!$assertionsDisabled && !(e.getChangeInfo() instanceof Position)) {
                    throw new AssertionError((Object)"assuming position of change is changeInfo");
                }
                Gameboard2.this.repaint((Position)e.getChangeInfo());
                Gameboard2.this.propertyChangeListeners.firePropertyChange("field", null, e.getField());
            }

            static {
                $assertionsDisabled = !(class$orbital$game$Gameboard2 == null ? (class$orbital$game$Gameboard2 = Gameboard2.class$("orbital.game.Gameboard2")) : class$orbital$game$Gameboard2).desiredAssertionStatus();
            }
        });
    }

    public Figure getFigure(Position p) {
        return this.field.getFigure(p);
    }

    public void setFigure(Position p, Figure what) {
        this.field.setFigure(p, what);
        this.propertyChangeListeners.firePropertyChange("field", null, this.field);
        this.repaint(p);
    }

    public Dimension getPreferredSize() {
        this.layouting = true;
        return this.field != null ? this.field.getPreferredSize() : super.getPreferredSize();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.removePropertyChangeListener(l);
    }

    public Position figureOn(int x, int y) {
        if (this.field == null) {
            return null;
        }
        Dimension dim = this.field.getDimension();
        return new Position(x * dim.width / this.size().width, y * dim.height / this.size().height);
    }

    public void paintComponent(Graphics g) {
        if (this.field == null) {
            return;
        }
        this.field.paint(g, new Rectangle(this.getSize()));
    }

    public void repaint(Position p) {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        Rectangle box = new Rectangle(this.getSize());
        Rectangle fr = this.field.boundsOf(box, p);
        Graphics fg = g.create(fr.x, fr.y, fr.width, fr.height);
        fr.setLocation(0, 0);
        fg.setColor((p.x & 1 ^ p.y & 1) == 0 ? Color.white : Color.darkGray);
        fg.fillRect(fr.x, fr.y, fr.width, fr.height);
        Figure f = this.field.getFigure(p);
        if (f != null) {
            f.paint(fg, fr);
        }
        fg.dispose();
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (infoflags == 32) {
            if (this.layouting) {
                this.doLayout();
            } else {
                this.repaint();
            }
            this.layouting = false;
            return false;
        }
        return true;
    }

    protected Move findValidPath(Figure source, Position destination) {
        Iterator i = source.possibleMoves();
        while (i.hasNext()) {
            AdversarySearch.Option o = (AdversarySearch.Option)i.next();
            Move move = o.getMove();
            Position dst = o.getDestination();
            if (!destination.equals(dst)) continue;
            if (!$assertionsDisabled && dst == null) {
                throw new AssertionError((Object)"destination.equals(null) == false");
            }
            return move;
        }
        return null;
    }

    static {
        $assertionsDisabled = !Gameboard2.class.desiredAssertionStatus();
        logger = Logger.getLogger(Gameboard.class.getName());
    }
}

