/*
 * Decompiled with CFR 0.152.
 */
package orbital.algorithm;

import java.util.Arrays;
import java.util.NoSuchElementException;
import orbital.algorithm.Combinatorical;
import orbital.util.SuspiciousError;

class RepetitivePermutation
extends Combinatorical {
    private static final long serialVersionUID = 787550243481366022L;
    private final int r;
    private final int n;
    private final int[] permutation;

    public RepetitivePermutation(int r, int n) {
        this.r = r;
        this.n = n;
        this.permutation = new int[r];
        Arrays.fill(this.permutation, 0);
        if (this.permutation.length > 0) {
            int n2 = this.permutation.length - 1;
            this.permutation[n2] = this.permutation[n2] - 1;
        }
    }

    public boolean hasNext() {
        for (int i = this.permutation.length - 1; i >= 0; --i) {
            if (this.permutation[i] + 1 >= this.n) continue;
            return true;
        }
        return false;
    }

    public int[] next() {
        if (this.permutation.length == 0) {
            return this.permutation;
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        for (int i = this.permutation.length - 1; i >= 0; --i) {
            int n = i;
            this.permutation[n] = this.permutation[n] + 1;
            if (this.permutation[n] < this.n) {
                return this.permutation;
            }
            this.permutation[i] = 0;
        }
        throw new SuspiciousError();
    }

    public boolean hasPrevious() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int[] previous() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int count() {
        return (int)Math.pow(this.n, this.r);
    }

    public String toString() {
        return this.getClass().getName() + "[of " + this.r + " elements out of " + this.n + "]";
    }
}

