/*
 * Decompiled with CFR 0.152.
 */
package functologic.game.computer;

import orbital.math.Arithmetic;
import orbital.math.Real;
import orbital.math.Values;
import orbital.math.functional.Function;
import orbital.math.functional.Functions;
import orbital.math.functional.Operations;
import orbital.moon.math.functional.AbstractFunctor;

final class ShiftedLogistic
extends AbstractFunctor
implements Function {
    private static final Values vf = Values.getDefaultInstance();

    ShiftedLogistic() {
    }

    public Object apply(Object object) {
        return vf.valueOf(2).multiply((Arithmetic)Functions.logistic.apply(object)).add(vf.valueOf(1));
    }

    public static float apply(float f) {
        return 2.0f / (1.0f + (float)Math.exp(-f)) - 1.0f;
    }

    public static float deriveApply(float f) {
        float f2 = 1.0f / (1.0f + (float)Math.exp(-f));
        return 2.0f * f2 * (1.0f - f2);
    }

    public Real norm() {
        return Values.ONE;
    }

    public Function derive() {
        return (Function)Operations.times.apply(vf.valueOf(2), Functions.logistic.derive());
    }

    public Function integrate() {
        throw new UnsupportedOperationException();
    }
}

