/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import orbital.awt.UIUtilities;
import orbital.game.AdversarySearch;
import orbital.game.Field;
import orbital.game.Figure;
import orbital.game.FigureImpl;
import orbital.logic.functor.Predicate;
import orbital.robotic.Direction;
import orbital.robotic.Move;
import orbital.robotic.Position;
import orbital.util.Setops;

class RhythmomachiaFigure
extends FigureImpl {
    private static final long serialVersionUID = 6056431694798124034L;
    private int rating;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RhythmomachiaFigure(int n, int n2, Direction direction, int n3, int n4, Image image, int n5) {
        super(n, n2, direction, n3, n4, image);
        this.rating = n5;
    }

    public RhythmomachiaFigure(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.rating = n5;
    }

    public Object clone() {
        RhythmomachiaFigure rhythmomachiaFigure = new RhythmomachiaFigure(this.x, this.y, new Direction(this.getDirection()), this.getLeague(), this.getType(), this.getImage(), this.getRating());
        rhythmomachiaFigure.setLegalMoves(this.getLegalMoves());
        return rhythmomachiaFigure;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int n) {
        this.rating = n;
    }

    public int getMoveDistance() {
        return RhythmomachiaRules.moveDistance[this.getType()];
    }

    public void setEmpty() {
        super.setEmpty();
        this.rating = 0;
    }

    private static int distance(Position position) {
        if (position.x == 0) {
            return Math.abs(position.y) + 1;
        }
        if (position.y == 0) {
            return Math.abs(position.x) + 1;
        }
        if (!$assertionsDisabled && Math.abs(position.x) != Math.abs(position.y)) {
            throw new AssertionError((Object)"Rhythmomachia rules only allow horizontal,vertical, or diagonal");
        }
        return Math.abs(position.x) + 1;
    }

    int getDistanceTo(Position position) {
        return RhythmomachiaFigure.distance(position.subtract(this));
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        Color color = this.getLeague() != 2 ? Game.game.getViewSettings().getBlackFontColor() : Game.game.getViewSettings().getWhiteFontColor();
        RhythmomachiaField rhythmomachiaField = (RhythmomachiaField)this.getField();
        if (rhythmomachiaField != null && rhythmomachiaField.getCoordinators() != null) {
            JointAttackCoordinator[] jointAttackCoordinatorArray = rhythmomachiaField.getCoordinators();
            if (this == jointAttackCoordinatorArray[1].getTarget()) {
                color = Game.game.getViewSettings().getBlackAttackedFontColor();
            }
            if (this == jointAttackCoordinatorArray[2].getTarget()) {
                color = Game.game.getViewSettings().getWhiteAttackedFontColor();
            }
        }
        this.paint(graphics, rectangle, color);
    }

    void paint(Graphics graphics, Rectangle rectangle, Color color) {
        super.paint(graphics, rectangle);
        if (!this.isEmpty()) {
            graphics.setColor(color);
            graphics.setFont(Game.game.getViewSettings().getRatingFont());
            UIUtilities.drawCenteredString(graphics, this.getRating() + "", rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return dimension != null ? dimension : new Dimension(32, 32);
    }

    protected boolean moving(Move move, Position position) {
        if (!super.moving(move, position)) {
            return false;
        }
        RhythmomachiaField rhythmomachiaField = (RhythmomachiaField)this.getField();
        RhythmomachiaFigure rhythmomachiaFigure = (RhythmomachiaFigure)rhythmomachiaField.getFigure(position);
        if (rhythmomachiaField.getTurn() != this.getLeague()) {
            return false;
        }
        if (rhythmomachiaFigure != null && !rhythmomachiaFigure.isEmpty()) {
            boolean bl;
            if (this.getLeague() == rhythmomachiaFigure.getLeague()) {
                return false;
            }
            if (!rhythmomachiaField.checkAllowAttackNow(this, rhythmomachiaFigure)) {
                return false;
            }
            JointAttackSettings jointAttackSettings = Game.game.getJointAttackSettings(rhythmomachiaField.getTurn());
            try {
                bl = rhythmomachiaField.getCoordinator().attack(this, (RhythmomachiaFigure)rhythmomachiaField.getFigure(rhythmomachiaFigure), jointAttackSettings.isAdding(), jointAttackSettings.isMultiplying());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            rhythmomachiaField.attackNow(this, rhythmomachiaFigure);
            if (bl) {
                rhythmomachiaFigure.tackledBy(this);
            }
            rhythmomachiaField.swap(new Position(this), new Position(rhythmomachiaFigure));
            return true;
        }
        if (rhythmomachiaField.hasMoved()) {
            return false;
        }
        rhythmomachiaField.doMoved(new Position(this), new Position(position));
        rhythmomachiaField.getCoordinator().move(this, position);
        return true;
    }

    protected void tackledBy(RhythmomachiaFigure rhythmomachiaFigure) {
        if (RhythmomachiaRules.curRules.isCapturing()) {
            RhythmomachiaField rhythmomachiaField = (RhythmomachiaField)this.getField();
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            int n4 = 1;
            switch (rhythmomachiaFigure.getLeague()) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = rhythmomachiaField.getDimension().width - 1;
                    n3 = -1;
                    break;
                }
                default: {
                    throw new InternalError("league what?");
                }
            }
            Figure figure = RhythmomachiaRules.curRules.newFigure(Integer.MIN_VALUE, Integer.MIN_VALUE, rhythmomachiaFigure.getLeague(), this.getType(), this.getRating());
            block4: for (int i = n; 0 <= i && i < rhythmomachiaField.getDimension().width; i += n3) {
                for (int j = n2; 0 <= j && j < rhythmomachiaField.getDimension().height; j += n4) {
                    Position position = new Position(i, j);
                    if (!rhythmomachiaField.isEmpty(position)) continue;
                    rhythmomachiaField.setFigure(position, figure);
                    Game.logger.log(Level.FINE, "repositioned capturee at {0}", position);
                    break block4;
                }
            }
        }
        this.setEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator possibleMoves() {
        Move[] moveArray = this.getLegalMoves();
        RhythmomachiaField rhythmomachiaField = (RhythmomachiaField)this.getField();
        try {
            if (RhythmomachiaRules.curRules.isAutoAttackOpportunities(rhythmomachiaField)) {
                RhythmomachiaRules.createSimplifiedMovesFor(this, this.getType(), rhythmomachiaField, true);
                super.setLegalMoves(RhythmomachiaRules.createSimplifiedMovesFor(this, this.getType(), rhythmomachiaField, false));
            } else {
                super.setLegalMoves(RhythmomachiaRules.createSimplifiedMovesFor(this, this.getType(), rhythmomachiaField, true));
            }
            Iterator iterator = super.possibleMoves();
            if (!$assertionsDisabled && !RhythmomachiaRules.curRules.isAutoAttackOpportunities(rhythmomachiaField) && (iterator = this.validatePossibleMoves(iterator, moveArray)) == null) {
                throw new AssertionError((Object)"our high-speed projection leads to the same set of possibleMoves when restricted to different-league targets, except when using auto attack opportunities");
            }
            Iterator iterator2 = iterator;
            super.setLegalMoves(moveArray);
            return iterator2;
        }
        catch (Throwable throwable) {
            try {
                super.setLegalMoves(moveArray);
                throw throwable;
            }
            catch (EncircledException encircledException) {
                System.err.println(encircledException);
                switch (RhythmomachiaRules.curRules.getEncircled()) {
                    case 0: {
                        throw (InternalError)new InternalError("should not occur").initCause(encircledException);
                    }
                    case 1: {
                        this.setEmpty();
                        this.getField().setFigure(this, this);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                return Collections.EMPTY_LIST.iterator();
            }
        }
    }

    final Iterator superpossibleMoves() {
        return super.possibleMoves();
    }

    final Iterator validatePossibleMoves(Iterator iterator, Move[] moveArray) {
        List list = Setops.asList(iterator);
        super.setLegalMoves(moveArray);
        List list2 = (List)Setops.createSelection(new Predicate(){

            public boolean apply(Object object) {
                AdversarySearch.Option option = (AdversarySearch.Option)object;
                Move move = option.getMove();
                Position position = option.getDestination();
                Figure figure = RhythmomachiaFigure.this.getField().getFigure(position);
                return figure == null || RhythmomachiaFigure.this.getLeague() != figure.getLeague();
            }
        }).apply(super.possibleMoves());
        if (!$assertionsDisabled && !new HashSet(list).equals(new HashSet(list2))) {
            throw new AssertionError((Object)("our high-speed projection leads to the same set of possibleMoves when restricted to different-league targets\nfor " + this + "\nprojection is   " + list + "\nbut original is " + list2));
        }
        return list.iterator();
    }

    public String toString() {
        return this.getClass().getName() + "[" + RhythmomachiaRules.leagueDescription(this.getLeague()) + ":" + RhythmomachiaRules.typeDescription(this.getType()) + ":" + this.getRating() + " @(" + this.x + '|' + this.y + ' ' + this.getDirection().toString() + ")]";
    }

    public void setField(Field field) {
        super.setField(field);
    }

    static {
        $assertionsDisabled = !RhythmomachiaFigure.class.desiredAssertionStatus();
    }
}

