/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

class KingView
extends JPanel {
    private static final int ROWS = 6;
    protected RhythmomachiaKing king;

    public KingView(int n) {
        this.setBackground(Color.gray.darker());
        this.setOpaque(true);
        this.setToolTipText(Game.game.getResources().getString("pane.kingView." + n + ".tooltip"));
        this.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent mouseEvent) {
                if (KingView.this.king == null) {
                    return;
                }
                try {
                    for (int i = 0; i < KingView.this.king.getContentCount(); ++i) {
                        if (!KingView.this.boundsOf(i).contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                        KingView.this.king.select(i);
                        return;
                    }
                    KingView.this.king.select(-1);
                }
                finally {
                    KingView.this.repaint();
                }
            }
        });
    }

    public RhythmomachiaKing getKing() {
        return this.king;
    }

    public void setKing(RhythmomachiaKing rhythmomachiaKing) {
        this.king = rhythmomachiaKing;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.king == null) {
            return super.getPreferredSize();
        }
        Dimension dimension = this.king.getPreferredSize();
        Dimension dimension2 = this.getParent().getSize();
        return new Dimension(Math.max(dimension.width, dimension2.width / 18), Math.min(dimension.height, dimension2.height / 10));
    }

    private Rectangle boundsOf(int n) {
        Rectangle rectangle = this.getBounds();
        int n2 = this.king.getContentCount();
        int n3 = rectangle.height / 6;
        Rectangle rectangle2 = new Rectangle(0, n3 * (n + (6 - n2)), rectangle.width, n3);
        rectangle2.grow(3 * (n + 1 - n2), 3 * (n + 1 - n2));
        return rectangle2;
    }

    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        rectangle.setLocation(0, 0);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        graphics.setColor(this.getForeground());
        if (this.king == null) {
            return;
        }
        RhythmomachiaFigure[] rhythmomachiaFigureArray = this.king.getContents();
        for (int i = 0; i < rhythmomachiaFigureArray.length; ++i) {
            Rectangle rectangle2 = this.boundsOf(i);
            Graphics graphics2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            rectangle2.x = 0;
            rectangle2.y = 0;
            if (rhythmomachiaFigureArray[i] != null) {
                rhythmomachiaFigureArray[i].paint(graphics2, rectangle2);
            } else {
                graphics2.clearRect(0, 0, rectangle2.width, rectangle2.height);
            }
            if (this.king.getSelectedIndex() == i) {
                rectangle2.grow(-2, -2);
                graphics2.setColor(Color.orange);
                ((Graphics2D)graphics2).setStroke(new BasicStroke(2.0f));
                graphics2.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            graphics2.dispose();
        }
        if (this.king.getSelectedIndex() == -1) {
            rectangle.grow(-2, -2);
            graphics.setColor(Color.orange);
            ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

