/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.JApplet;
import orbital.awt.CustomizerViewController;
import orbital.awt.UIUtilities;
import orbital.game.Field;
import orbital.game.FieldChangeAdapter;
import orbital.game.FieldChangeEvent;
import orbital.game.Figure;
import orbital.game.FigureImpl;
import orbital.game.GameView2;
import orbital.logic.functor.Function;
import orbital.moon.awt.AppletFrame;

public class Game
extends GameView2 {
    static final Logger logger;
    public static Game game;
    private boolean alwaysRepaint;
    private JointAttackSettings[] settings;
    private ViewSettings viewSettings;
    private ControlPanel controls;
    private KingView[] kingView;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2;
        Game game = new Game();
        if (stringArray.length != 0) {
            stringArray2 = Game.concat(stringArray, new String[]{"gameRules=RhythmomachiaRules", "gameName=Rhythmomachia - The Philosopher's Game"});
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "gameRules=RhythmomachiaRules";
            stringArray2 = stringArray3;
            stringArray3[1] = "gameName=Rhythmomachia - The Philosopher's Game";
        }
        AppletFrame.showApplet(game, "Rhythmomachia", stringArray2);
    }

    private static String[] concat(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public Game() {
        if (game != null) {
            throw new IllegalStateException("singleton");
        }
        game = this;
        Dictionary dictionary = this.getActions();
        dictionary.put("preferences", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerViewController customizerViewController = new CustomizerViewController(UIUtilities.getParentalFrame(Game.this));
                LinkedList<Object> linkedList = new LinkedList<Object>();
                linkedList.add(RhythmomachiaRules.curRules);
                linkedList.add(Game.this.getViewSettings());
                Function[] functionArray = Game.this.getPlayers();
                for (int i = 1; i < functionArray.length; ++i) {
                    if (functionArray[i] == null) continue;
                    linkedList.add(functionArray[i]);
                }
                customizerViewController.showCustomizer(linkedList.toArray());
                Game.this.repaint();
            }
        });
        dictionary.put("exit", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.viewSettings = new ViewSettings();
    }

    public JointAttackSettings getJointAttackSettings(int n) {
        return this.settings[n];
    }

    ControlPanel getControlPanel() {
        return this.controls;
    }

    KingView[] getKingView() {
        return this.kingView;
    }

    ViewSettings getViewSettings() {
        return this.viewSettings;
    }

    protected Container createControl() {
        Container container = this instanceof JApplet ? this.getContentPane() : this;
        Container container2 = super.createControl();
        this.controls = new ControlPanel();
        container2.add((Component)this.controls, "Center");
        this.kingView = new KingView[this.getGameRules().getLeagues()];
        if (!$assertionsDisabled && this.kingView.length != 3) {
            throw new AssertionError((Object)"");
        }
        this.kingView[1] = new KingView(1);
        container.add((Component)this.kingView[1], "West");
        this.kingView[2] = new KingView(2);
        container.add((Component)this.kingView[2], "East");
        return container2;
    }

    public void init() {
        super.init();
        String string = this.getParameter("repaint");
        this.alwaysRepaint = "true".equalsIgnoreCase(string);
        this.settings = new JointAttackSettings[RhythmomachiaRules.curRules.getLeagues()];
        for (int i = 1; i < this.settings.length; ++i) {
            this.settings[i] = new JointAttackSettings();
        }
    }

    protected void setField(Field field) {
        Field field2 = this.getGameboard().getField();
        if (field2 != null) {
            field2.removeFieldChangeListener(this.getControlPanel());
        }
        super.setField(field);
        Field field3 = this.getGameboard().getField();
        field3.addFieldChangeListener(this.getControlPanel());
        if (this.alwaysRepaint) {
            field3.addFieldChangeListener(new FieldChangeAdapter(){

                public void movePerformed(FieldChangeEvent fieldChangeEvent) {
                    Game.this.repaint();
                }
            });
        }
        KingView[] kingViewArray = this.getKingView();
        for (int i = 1; i < kingViewArray.length; ++i) {
            RhythmomachiaKing rhythmomachiaKing = RhythmomachiaRules.kingExists(i, field3);
            kingViewArray[i].setKing(rhythmomachiaKing);
            Iterator iterator = rhythmomachiaKing.getAllComponents();
            while (iterator.hasNext()) {
                Figure figure = (Figure)iterator.next();
                if (!(figure instanceof FigureImpl)) continue;
                ((FigureImpl)figure).setImage(this.getGameRules().getImage(figure));
            }
        }
    }

    public void load(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        super.load(objectInputStream);
        this.getControlPanel().stateChanged(new FieldChangeEvent(this.getGameboard().getField(), 32, "load"));
    }

    public ResourceBundle getResources() {
        return super.getResources();
    }

    static {
        $assertionsDisabled = !Game.class.desiredAssertionStatus();
        logger = Logger.getLogger("Rhythmomachia");
        game = null;
    }
}

